/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.nsg.metadata;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ETSAssert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class MetadataTests
extends CommonFixture {
    private static final Logger LOG = Logger.getLogger(MetadataTests.class.getName());

    @Test(description="Validate against NMIS schema")
    public void metadataSchemaValidation() throws SQLException {
        Schema schema = this.createSchema();
        if (schema == null) {
            throw new SkipException("Schema required for validation could not be loaded.");
        }
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT metadata FROM gpkg_metadata;");){
            while (resultSet.next()) {
                String xmlResult = resultSet.getString("metadata");
                Validator validator = schema.newValidator();
                StreamSource source = new StreamSource(new ByteArrayInputStream(xmlResult.getBytes()));
                ETSAssert.assertSchemaValid((Validator)validator, (Source)source);
            }
        }
    }

    private Schema createSchema() {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/opengis/cite/gpkg12/nsg/metadata/NMIS_v2.X_Schema/nas/nmis.xsd");
            return schemaFactory.newSchema(resource);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not load schema 'mis.xsd'", e);
            return null;
        }
    }
}

