/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.nsg.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.referencing.CRS;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.nsg.util.CrsList;
import org.opengis.cite.gpkg12.nsg.util.CrsListingUtils;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class NSG_SpatialReferenceSystemsTests
extends CommonFixture {
    private static final Logger LOG = Logger.getLogger(NSG_SpatialReferenceSystemsTests.class.getName());
    private static final String ANNEX_C_3395_TABLE = "Annex_C_3395_Table.txt";
    private static final String ANNEX_E_4326_TABLE = "Annex_E_4326_Table.txt";
    private static final double TOLERANCE = 1.0E-10;
    private CrsList crsListing;

    @BeforeClass
    public void parseCrsListing() {
        this.crsListing = CrsListingUtils.parseCrsListing();
    }

    @Test(groups={"NSG"}, description="NSG Req 3 (identified CRSs)")
    public void crsTest() throws SQLException {
        if (this.crsListing == null) {
            throw new SkipException("No designated CRS Lookup Table available");
        }
        String queryStr = "SELECT srs_id, organization_coordsys_id FROM gpkg_spatial_ref_sys";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery(queryStr);){
            LinkedList<String> invalidSrsIds = new LinkedList<String>();
            LinkedList<String> invalidOrgIds = new LinkedList<String>();
            while (resultSet.next()) {
                String srsID = resultSet.getString("srs_id").trim();
                String orgID = resultSet.getString("organization_coordsys_id").trim();
                if (srsID.equals("0") || orgID.equals("0") || srsID.equals("-1") || orgID.equals("-1")) continue;
                String crsOrgID = this.crsListing.getOrganizationCoordsysIdBySrsId(srsID);
                if (crsOrgID == null) {
                    invalidSrsIds.add(srsID);
                    continue;
                }
                if (crsOrgID.equals(orgID)) continue;
                invalidOrgIds.add(orgID);
            }
            resultSet.close();
            statement.close();
            Assert.assertTrue((boolean)invalidSrsIds.isEmpty(), (String)MessageFormat.format("The gpkg_spatial_ref_sys table contains invalid srs_id values {0}", invalidSrsIds.stream().map(Object::toString).collect(Collectors.joining(", "))));
            Assert.assertTrue((boolean)invalidOrgIds.isEmpty(), (String)MessageFormat.format("The gpkg_spatial_ref_sys table contains invalid organization_coordsys_id values {0}", invalidOrgIds.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
    }

    @Test(groups={"NSG"}, description="NSG Req 4 & 5 (match Annex table)")
    public void matchAnnexTableTest() throws SQLException {
        LinkedList<String> invalidMatrixEntries = new LinkedList<String>();
        boolean hasTileMatrixTable = DatabaseUtility.doesTableOrViewExist((Connection)this.databaseConnection, (String)"gpkg_tile_matrix");
        if (hasTileMatrixTable) {
            String queryStr = "SELECT tm.table_name AS tabName, sel.data_type AS dataTyp, sel.crs_id AS crsID, tm.zoom_level AS zoomLvl, tm.matrix_width AS matrixW, tm.matrix_height AS matrixH, tm.tile_width AS tileW, tm.tile_height AS tileH, tm.pixel_x_size AS pixelSzX, tm.pixel_y_size AS pixelSzY FROM gpkg_tile_matrix tm INNER JOIN (SELECT gc.table_name, gc.data_type, gs.organization_coordsys_id as crs_id  from gpkg_contents gc inner join gpkg_spatial_ref_sys gs where gc.srs_id=gs.srs_id) AS sel ON tm.table_name=sel.table_name WHERE crsID IN (3395, 4326) ORDER BY zoomLvl;";
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery(queryStr);){
                List<Object[]> annexC_3395 = this.populateAnnex(ANNEX_C_3395_TABLE, "Annex C (EPSG:3395)");
                List<Object[]> annexE_4326 = this.populateAnnex(ANNEX_E_4326_TABLE, "Annex E (EPSG:4326)");
                while (resultSet.next()) {
                    String tabNam = resultSet.getString("tabName").trim();
                    String srsID = resultSet.getString("crsID").trim();
                    int zoomLvl = resultSet.getInt("zoomLvl");
                    long matrixW = resultSet.getLong("matrixW");
                    long matrixH = resultSet.getLong("matrixH");
                    double pixelSzX = resultSet.getDouble("pixelSzX");
                    double pixelSzY = resultSet.getDouble("pixelSzY");
                    List<Object[]> annexTable = this.selectAnnexBySrsId(srsID, annexC_3395, annexE_4326);
                    for (Object[] obj : annexTable) {
                        if (zoomLvl != (Integer)obj[0]) continue;
                        long imW = (Long)obj[3];
                        long imH = (Long)obj[4];
                        double pX = (Double)obj[2];
                        double pY = (Double)obj[2];
                        if (Math.abs(pX - pixelSzX) > 1.0E-10) {
                            invalidMatrixEntries.add(tabNam + " (" + srsID + ", Zoom Level: " + zoomLvl + "): Pixel Size X: " + pixelSzX + "; but expected " + pX);
                            continue;
                        }
                        if (Math.abs(pY - pixelSzY) > 1.0E-10) {
                            invalidMatrixEntries.add(tabNam + " (" + srsID + ", Zoom Level: " + zoomLvl + "): Pixel Size Y: " + pixelSzY + "; but expected " + pY);
                            continue;
                        }
                        if (imW != matrixW) {
                            invalidMatrixEntries.add(tabNam + " (" + srsID + ", Zoom Level: " + zoomLvl + "): Matrix Width: " + matrixW + "; but expected " + imW);
                            continue;
                        }
                        if (imH == matrixH) continue;
                        invalidMatrixEntries.add(tabNam + " (" + srsID + ", Zoom Level: " + zoomLvl + "): Matrix Height: " + matrixH + "; but expected " + imH);
                    }
                }
                Assert.assertTrue((boolean)invalidMatrixEntries.isEmpty(), (String)MessageFormat.format("The gpkg_tile_matrix table contains invalid Pixels Size or Matrix Size values for tables: {0}", invalidMatrixEntries.stream().map(Object::toString).collect(Collectors.joining(", "))));
            }
        }
    }

    @Test(groups={"NSG"}, description="NSG Req 8 & 9 (CRS definitions)")
    public void crsDefinitionsTest() throws SQLException {
        if (this.crsListing == null) {
            throw new SkipException("No designated CRS Lookup Table available");
        }
        String queryStr = "SELECT srs_id,definition FROM gpkg_spatial_ref_sys";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery(queryStr);){
            LinkedList<String> invalidSrsDefs = new LinkedList<String>();
            while (resultSet.next()) {
                boolean found;
                String srsID = resultSet.getString("srs_id").trim();
                if (srsID.equals("0") || srsID.equals("-1")) continue;
                String definition = resultSet.getString("definition");
                String expectedDefinition = this.crsListing.getDefinitionBySrsId(srsID);
                if (definition == null || (found = expectedDefinition != null && this.compareDefintion(definition, expectedDefinition))) continue;
                try {
                    String code = "";
                    try {
                        CoordinateReferenceSystem example = CRS.parseWKT((String)definition);
                        code = CRS.lookupIdentifier((IdentifiedObject)example, (boolean)true);
                    }
                    catch (FactoryException e) {
                        invalidSrsDefs.add(srsID + ":" + definition + " : " + e.getMessage());
                        Assert.fail((String)MessageFormat.format("The gpkg_spatial_ref_sys table error srs_id, wkt, error: {0}", invalidSrsDefs.stream().map(Object::toString).collect(Collectors.joining(", "))));
                    }
                    try {
                        CoordinateReferenceSystem e = CRS.decode((String)code);
                    }
                    catch (FactoryException e) {
                        invalidSrsDefs.add(srsID + ":" + definition + ": " + code + ":" + e.getMessage());
                        Assert.fail((String)MessageFormat.format("The gpkg_spatial_ref_sys table contains invalid CRS defintions values for IDs {0}", invalidSrsDefs.stream().map(Object::toString).collect(Collectors.joining(", "))));
                    }
                }
                catch (Exception ex) {
                    invalidSrsDefs.add(srsID + ":" + definition + " : " + ex.getMessage());
                    LOG.log(Level.WARNING, "The gpkg_spatial_ref_sys table could not be examined for IDs due to processing exception.", invalidSrsDefs.stream().map(Object::toString).collect(Collectors.joining(", ")));
                }
            }
        }
    }

    @Test(groups={"NSG"}, description="NSG Req 19-A (Data Validity: gpkg_spatial_ref_sys)")
    public void dataValidity_gpkg_spatial_ref_sys() throws SQLException {
        if (this.crsListing == null) {
            throw new SkipException("No designated CRS Lookup Table available");
        }
        String queryStr = "SELECT srs_id,organization,description FROM gpkg_spatial_ref_sys;";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery(queryStr);){
            LinkedList<String> invalidOrgs = new LinkedList<String>();
            LinkedList<String> invalidDesc = new LinkedList<String>();
            while (resultSet.next()) {
                String srsID = resultSet.getString("srs_id").trim();
                if ("0".equals(srsID) || "-1".equals(srsID)) continue;
                String srsOrg = resultSet.getString("organization");
                this.validateCrsOrganistion(srsID, srsOrg, invalidOrgs);
                String description = resultSet.getString("description");
                this.validateCrsDescription(srsID, description, invalidDesc);
            }
            Assert.assertTrue((boolean)invalidOrgs.isEmpty(), (String)MessageFormat.format("The gpkg_spatial_ref_sys table contains invalid organization values for IDs: {0}, should be 'EPSG' or 'NGA'", invalidOrgs.stream().map(Object::toString).collect(Collectors.joining(", "))));
            Assert.assertTrue((boolean)invalidDesc.isEmpty(), (String)MessageFormat.format("The gpkg_spatial_ref_sys table contains invalid descriptions for IDs: {0}", invalidDesc.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
    }

    private void validateCrsOrganistion(String srsID, String srsOrg, Collection<String> invalidOrgs) {
        if (srsOrg == null) {
            invalidOrgs.add(srsID + ": null (expected 'EPSG' or 'NGA')");
        } else if (!"EPSG".equalsIgnoreCase(srsOrg = srsOrg.trim()) && !"NGA".equalsIgnoreCase(srsOrg)) {
            invalidOrgs.add(srsID + ": " + srsOrg + " (expected 'EPSG' or 'NGA')");
        }
    }

    private void validateCrsDescription(String srsID, String description, Collection<String> invalidDesc) {
        if (description == null) {
            invalidDesc.add(srsID + " (expected not to be null)");
            return;
        }
        if (!this.isCrsDescriptionValid(description)) {
            invalidDesc.add(srsID + ": '" + description + "' (expected not to be an empty string, not all whitespace, not \u201cunknown\u201d (any case), not \u201ctbd\u201d (any case))");
            return;
        }
        String expectedDescription = this.crsListing.getDescriptionBySrsId(srsID);
        if (expectedDescription != null && !this.isDescriptionAsExpected(description, expectedDescription)) {
            invalidDesc.add(srsID + " : '" + description + "' (expected: '" + expectedDescription + "')");
        }
    }

    private boolean isDescriptionAsExpected(String descriptionToTest, String expectedDescription) {
        descriptionToTest = this.removeWhitespaces(descriptionToTest);
        expectedDescription = this.removeWhitespaces(expectedDescription);
        if (descriptionToTest.endsWith(".")) {
            descriptionToTest = descriptionToTest.substring(0, descriptionToTest.length() - 1);
        }
        if (expectedDescription.endsWith(".")) {
            expectedDescription = expectedDescription.substring(0, expectedDescription.length() - 1);
        }
        return descriptionToTest.equalsIgnoreCase(expectedDescription);
    }

    private boolean compareDefintion(String definitionToTest, String expectedDefinition) {
        definitionToTest = this.removeWhitespaces(definitionToTest);
        expectedDefinition = this.removeWhitespaces(expectedDefinition);
        return definitionToTest.equalsIgnoreCase(expectedDefinition);
    }

    private List<Object[]> selectAnnexBySrsId(String srsID, List<Object[]> annexC_3395, List<Object[]> annexE_4326) {
        if (srsID.equals("3395")) {
            return annexC_3395;
        }
        if (srsID.equals("4326")) {
            return annexE_4326;
        }
        if (srsID.equals("5041") || srsID.equals("5042")) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Object[]> populateAnnex(String annexTableName, String annexName) {
        InputStream resourceToRead = ((Object)((Object)this)).getClass().getResourceAsStream(annexTableName);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(resourceToRead, "UTF-8"));){
            String line;
            ArrayList<Object[]> annexEntries = new ArrayList<Object[]>();
            while ((line = br.readLine()) != null) {
                List<String> items = Arrays.asList(line.split("\\s*,\\s*"));
                if (items.isEmpty()) throw new SkipException(annexName + " Table is corrupt ");
                if (items.size() != 5) throw new SkipException(annexName + " Table is corrupt ");
                this.addNewEntry(annexEntries, items.get(0), items.get(1), items.get(2), items.get(3), items.get(4));
            }
            ArrayList<Object[]> arrayList = annexEntries;
            return arrayList;
        }
        catch (IOException e) {
            throw new SkipException(annexName + " Table not available");
        }
    }

    private void addNewEntry(List<Object[]> table, String zoom, String scale, String pixelSz, String matrixWidth, String matrixHeight) {
        int zoomAsInt = Integer.parseInt(zoom);
        double scaleAsDouble = Double.parseDouble(scale);
        double pixelSizeAsDouble = Double.parseDouble(pixelSz);
        long matrixWidthAsLong = Long.parseLong(matrixWidth);
        long matrixHeightAsLong = Long.parseLong(matrixHeight);
        Object[] row = new Object[]{zoomAsInt, scaleAsDouble, pixelSizeAsDouble, matrixWidthAsLong, matrixHeightAsLong};
        table.add(row);
    }

    private String removeWhitespaces(String description) {
        if (description != null) {
            return description.trim().replaceAll("\\s+", "");
        }
        return description;
    }

    private boolean isCrsDescriptionValid(String srsDesc) {
        return srsDesc.length() > 0 && srsDesc.trim().length() > 0 && !srsDesc.equalsIgnoreCase("NULL") && !srsDesc.equalsIgnoreCase("UNK") && !srsDesc.equalsIgnoreCase("UNKNOWN") && !srsDesc.equalsIgnoreCase("TBD");
    }
}

