/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.GPKG12;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class SQLiteContainerTests
extends CommonFixture {
    private static final Set<String> CoreDataTypes = new HashSet<String>();
    private static final Map<String, Set<String>> CoreTables = new HashMap<String, Set<String>>();

    @Test(description="See OGC 12-128r12: Requirement 1")
    public void fileHeaderString() throws IOException {
        byte[] headerString = new byte[GPKG12.SQLITE_MAGIC_HEADER.length];
        try (FileInputStream fileInputStream = new FileInputStream(this.gpkgFile);){
            fileInputStream.read(headerString);
        }
        Assert.assertTrue((boolean)Arrays.equals(headerString, GPKG12.SQLITE_MAGIC_HEADER), (String)ErrorMessage.format("InvalidHeaderString", new String(headerString, StandardCharsets.US_ASCII)));
    }

    @Test(description="See OGC 12-128r12: Requirement 2")
    public void applicationID() throws IOException, SQLException {
        CommonFixture.GeoPackageVersion version = this.getGeopackageVersion();
        Assert.assertTrue((version != null ? 1 : 0) != 0, (String)ErrorMessage.format("UnknownApplicationId", new String(this.getAppId(), StandardCharsets.US_ASCII)));
        Assert.assertTrue((boolean)Arrays.asList(this.getAllowedVersions()).contains((Object)version), (String)ErrorMessage.format("UnknownApplicationId", new Object[0]));
        if (version.equals((Object)CommonFixture.GeoPackageVersion.V120)) {
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("PRAGMA user_version");){
                int versionNumber;
                String versionStr;
                if (resultSet.next()) {
                    versionStr = resultSet.getString(1);
                    versionNumber = Integer.parseInt(versionStr);
                } else {
                    versionNumber = 0;
                    versionStr = "";
                }
                Assert.assertTrue((versionNumber >= 10200 ? 1 : 0) != 0, (String)ErrorMessage.format("UnknownApplicationId", versionStr));
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 3")
    public void filenameExtension() {
        String fileName = this.gpkgFile.getName();
        String suffix = fileName.substring(fileName.lastIndexOf(46));
        Assert.assertEquals((String)suffix, (String)".gpkg", (String)ErrorMessage.format("InvalidSuffix", suffix));
    }

    @Test(description="See OGC 12-128r12: Requirement 4")
    public void fileContents() throws SQLException {
        Throwable throwable;
        try (Statement statement12 = this.databaseConnection.createStatement();){
            throwable = null;
            try (ResultSet resultSet1 = statement12.executeQuery("SELECT COUNT(*) FROM gpkg_extensions;");){
                if (resultSet1.getInt(1) > 0) {
                    return;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (SQLException statement12) {
            // empty catch block
        }
        for (String tableName : CoreTables.keySet()) {
            try {
                Statement statement2 = this.databaseConnection.createStatement();
                throwable = null;
                try {
                    ResultSet resultSet2 = statement2.executeQuery(String.format("PRAGMA table_info(%s)", tableName));
                    Throwable throwable3 = null;
                    try {
                        while (resultSet2.next()) {
                            String columnName = resultSet2.getString("name");
                            Assert.assertTrue((boolean)CoreTables.get(tableName).contains(columnName), (String)ErrorMessage.format("UnexpectedColumn", columnName, tableName));
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (resultSet2 == null) continue;
                        if (throwable3 != null) {
                            try {
                                resultSet2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        resultSet2.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (statement2 == null) continue;
                    if (throwable != null) {
                        try {
                            statement2.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    statement2.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        try (Statement statement3 = this.databaseConnection.createStatement();
             ResultSet resultSet3 = statement3.executeQuery("SELECT DISTINCT data_type FROM gpkg_contents;");){
            while (resultSet3.next()) {
                String dataType = resultSet3.getString("data_type");
                Assert.assertTrue((boolean)CoreDataTypes.contains(dataType), (String)ErrorMessage.format("InvalidDataType", dataType, "gpkg_contents"));
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 6")
    public void pragmaIntegrityCheck() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA integrity_check;");){
            resultSet.next();
            Assert.assertEquals((String)resultSet.getString("integrity_check").toLowerCase(), (String)"ok", (String)ErrorMessage.format("PragmaIntegrityCheckNotOk", new Object[0]));
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 7")
    public void foreignKeyCheck() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA foreign_key_check;");){
            Assert.assertTrue((!resultSet.next() ? 1 : 0) != 0, (String)ErrorMessage.format("InvalidForeignKey", new Object[0]));
        }
    }

    /*
     * Loose catch block
     */
    @Test(description="See OGC 12-128r12: Requirement 8")
    public void sqlCheck() throws SQLException {
        try {
            Statement stmt = this.databaseConnection.createStatement();
            Throwable throwable = null;
            ResultSet result = stmt.executeQuery("SELECT * FROM sqlite_master;");
            Throwable throwable2 = null;
            if (result != null) {
                if (throwable2 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                } else {
                    result.close();
                }
            }
            return;
            {
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            AssertJUnit.fail((String)ErrorMessage.format("NoSqlAccess", new Object[0]));
            return;
        }
    }

    static {
        HashSet<String> contentsColumns = new HashSet<String>();
        contentsColumns.add("table_name");
        contentsColumns.add("data_type");
        contentsColumns.add("identifier");
        contentsColumns.add("description");
        contentsColumns.add("last_change");
        contentsColumns.add("min_x");
        contentsColumns.add("min_y");
        contentsColumns.add("max_x");
        contentsColumns.add("max_y");
        contentsColumns.add("srs_id");
        CoreTables.put("gpkg_contents", contentsColumns);
        HashSet<String> srsColumns = new HashSet<String>();
        srsColumns.add("srs_name");
        srsColumns.add("srs_id");
        srsColumns.add("organization");
        srsColumns.add("description");
        srsColumns.add("organization_coordsys_id");
        srsColumns.add("definition");
        CoreTables.put("gpkg_spatial_ref_sys", srsColumns);
        HashSet<String> geometryColumns = new HashSet<String>();
        geometryColumns.add("table_name");
        geometryColumns.add("column_name");
        geometryColumns.add("geometry_type_name");
        geometryColumns.add("srs_id");
        geometryColumns.add("z");
        geometryColumns.add("m");
        CoreTables.put("gpkg_geometry_columns", geometryColumns);
        HashSet<String> tileMatrixSetColumns = new HashSet<String>();
        tileMatrixSetColumns.add("table_name");
        tileMatrixSetColumns.add("srs_id");
        tileMatrixSetColumns.add("min_x");
        tileMatrixSetColumns.add("min_y");
        tileMatrixSetColumns.add("max_x");
        tileMatrixSetColumns.add("max_y");
        CoreTables.put("gpkg_tile_matrix_set", tileMatrixSetColumns);
        HashSet<String> tileMatrixColumns = new HashSet<String>();
        tileMatrixColumns.add("table_name");
        tileMatrixColumns.add("zoom_level");
        tileMatrixColumns.add("matrix_width");
        tileMatrixColumns.add("matrix_height");
        tileMatrixColumns.add("tile_width");
        tileMatrixColumns.add("tile_height");
        tileMatrixColumns.add("pixel_x_size");
        tileMatrixColumns.add("pixel_y_size");
        CoreTables.put("gpkg_tile_matrix", tileMatrixColumns);
        HashSet<String> extensionsColumns = new HashSet<String>();
        extensionsColumns.add("table_name");
        extensionsColumns.add("column_name");
        extensionsColumns.add("extension_name");
        extensionsColumns.add("definition");
        extensionsColumns.add("scope");
        CoreTables.put("gpkg_extensions", extensionsColumns);
        CoreDataTypes.add("tiles");
        CoreDataTypes.add("features");
        CoreDataTypes.add("attributes");
    }
}

