/*
 * Decompiled with CFR 0.152.
 */
package com.bric.math;

import java.util.Arrays;
import java.util.Comparator;

public class Equations {
    public static boolean VERBOSE_EXCEPTIONS = true;
    private static Comparator<double[]> coefficientComparator = new Comparator<double[]>(){

        @Override
        public int compare(double[] d1, double[] d2) {
            int a;
            int v1 = 0;
            int v2 = 0;
            for (a = 0; a < d1.length; ++a) {
                if (d1[a] != 1.0) continue;
                v1 = a;
                a = d1.length;
            }
            for (a = 0; a < d2.length; ++a) {
                if (d2[a] != 1.0) continue;
                v2 = a;
                a = d2.length;
            }
            return v1 - v2;
        }
    };

    public static String toString(double[][] d) {
        Object s2 = "";
        for (int a = 0; a < d.length; ++a) {
            s2 = (String)s2 + Equations.toString(d[a]) + "\n";
        }
        return ((String)s2).trim();
    }

    public static String toString(double[] d) {
        Object s2 = "[";
        for (int a = 0; a < d.length; ++a) {
            s2 = a == 0 ? (String)s2 + " " + d[a] : (String)s2 + ", " + d[a];
        }
        return (String)s2 + " ]";
    }

    public static void solve(double[][] coefficients) {
        Equations.solve(coefficients, true);
    }

    public static void solve(double[][] coefficients, boolean sort) {
        int i;
        int a;
        double t2;
        if (coefficients == null) {
            throw new NullPointerException("The coefficients matrix is null.");
        }
        int size = coefficients.length;
        boolean[] b = new boolean[coefficients.length];
        int[] order = new int[b.length];
        int ctr = 0;
        int row = 0;
        int errorCounter = 0;
        while (ctr < b.length) {
            if (coefficients[row].length != size + 1) {
                throw new IllegalArgumentException("The matrix must be N x (N+1) units long.  The matrix provided is " + size + " x " + coefficients[row].length + " units.");
            }
            if (!b[row] && Math.abs(coefficients[row][ctr]) > 1.0E-10) {
                errorCounter = 0;
                t2 = 1.0 / coefficients[row][ctr];
                a = 0;
                while (a < coefficients[row].length) {
                    double[] dArray = coefficients[row];
                    int n = a++;
                    dArray[n] = dArray[n] * t2;
                }
                coefficients[row][ctr] = 1.0;
                b[row] = true;
                for (a = 0; a < coefficients.length; ++a) {
                    if (b[a]) continue;
                    t2 = coefficients[a][ctr];
                    for (i = 0; i < coefficients[a].length; ++i) {
                        double[] dArray = coefficients[a];
                        int n = i;
                        dArray[n] = dArray[n] - coefficients[row][i] * t2;
                    }
                }
                order[ctr++] = row;
            }
            ++row;
            row %= coefficients.length;
            if (++errorCounter <= coefficients.length) continue;
            if (VERBOSE_EXCEPTIONS) {
                throw new IllegalArgumentException("The coefficient matrix cannot be solved.  Either it has infinitely many solutions, or zero solutions:\n" + Equations.toString(coefficients));
            }
            throw new IllegalArgumentException("The coefficient matrix cannot be solved.  Either it has infinitely many solutions, or zero solutions.");
        }
        ctr = 0;
        for (a = order.length - 2; a >= 0; --a) {
            row = order[a];
            for (i = coefficients[row].length - 2; i > a; --i) {
                t2 = coefficients[row][i] * coefficients[order[i]][coefficients[row].length - 1];
                double[] dArray = coefficients[row];
                int n = coefficients[row].length - 1;
                dArray[n] = dArray[n] - t2;
                coefficients[row][i] = 0.0;
            }
        }
        if (sort) {
            Arrays.sort(coefficients, coefficientComparator);
        }
    }
}

