/*
 * Decompiled with CFR 0.152.
 */
package com.bric.math.function;

import com.bric.math.Equations;
import com.bric.math.function.Function;

public class PolynomialFunction
implements Function {
    double[] coeffs;

    public static PolynomialFunction createFit(double x1, double y1, double x2, double y2) {
        return new PolynomialFunction(new double[]{(y2 - y1) / (-x1 + x2), (y1 * x2 - y2 * x1) / (-x1 + x2)});
    }

    public static PolynomialFunction createFit(double[] xs, double[] ys) {
        if (ys.length != xs.length) {
            throw new IllegalArgumentException("xs.length (" + xs.length + ") != ys.length (" + ys.length + ")");
        }
        double[][] coefficientsMatrix = new double[ys.length][ys.length + 1];
        for (int row = 0; row < coefficientsMatrix.length; ++row) {
            for (int column = 0; column < coefficientsMatrix[row].length - 1; ++column) {
                int power = ys.length - column - 1;
                coefficientsMatrix[row][column] = Math.pow(xs[row], power);
            }
            coefficientsMatrix[row][coefficientsMatrix[row].length - 1] = ys[row];
        }
        Equations.solve(coefficientsMatrix, true);
        double[] coeffs = new double[coefficientsMatrix.length];
        for (int a = 0; a < coeffs.length; ++a) {
            coeffs[a] = coefficientsMatrix[a][coefficientsMatrix[a].length - 1];
        }
        return new PolynomialFunction(coeffs);
    }

    public static PolynomialFunction createFit(double[] xs, double[] ys, double[] yDerivatives) {
        if (ys.length != yDerivatives.length) {
            throw new IllegalArgumentException("ys.length (" + ys.length + ") != yDerivatives.length (" + yDerivatives.length + ")");
        }
        if (ys.length != xs.length) {
            throw new IllegalArgumentException("xs.length (" + xs.length + ") != ys.length (" + ys.length + ")");
        }
        double[][] coefficientsMatrix = new double[ys.length * 2][ys.length * 2 + 1];
        for (int row = 0; row < coefficientsMatrix.length; row += 2) {
            for (int column = 0; column < coefficientsMatrix[row].length - 1; ++column) {
                int power = ys.length * 2 - column - 1;
                coefficientsMatrix[row][column] = Math.pow(xs[row / 2], power);
                coefficientsMatrix[row + 1][column] = power == 0 ? 0.0 : (double)power * Math.pow(xs[row / 2], power - 1);
            }
            coefficientsMatrix[row][coefficientsMatrix[row].length - 1] = ys[row / 2];
            coefficientsMatrix[row + 1][coefficientsMatrix[row].length - 1] = yDerivatives[row / 2];
        }
        Equations.solve(coefficientsMatrix, true);
        double[] coeffs = new double[coefficientsMatrix.length];
        for (int a = 0; a < coeffs.length; ++a) {
            coeffs[a] = coefficientsMatrix[a][coefficientsMatrix[a].length - 1];
        }
        return new PolynomialFunction(coeffs);
    }

    public PolynomialFunction(double[] coeffs) {
        this.coeffs = new double[coeffs.length];
        System.arraycopy(coeffs, 0, this.coeffs, 0, coeffs.length);
    }

    @Override
    public double evaluate(double x) {
        double result = this.coeffs[0];
        int n = this.coeffs.length;
        for (int a = 1; a < n; ++a) {
            result = result * x + this.coeffs[a];
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("y = ");
        for (int a = 0; a < this.coeffs.length; ++a) {
            int degree = this.coeffs.length - a - 1;
            if (degree == 0) {
                sb.append(this.coeffs[a]);
            } else {
                sb.append(this.coeffs[a] + "*(x^" + degree + ")");
            }
            if (a == this.coeffs.length - 1) continue;
            sb.append("+");
        }
        return sb.toString();
    }

    @Override
    public double[] evaluateInverse(double y) {
        if (this.coeffs.length == 2) {
            double x = (y - this.coeffs[1]) / this.coeffs[0];
            return new double[]{x};
        }
        throw new UnsupportedOperationException();
    }
}

