/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.tools;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;

public class SignatureChecker {
    private static final String WILDCARD = "%";
    private static final String[] SYSTEM_SCHEMAS = new String[]{"SQLJ", "SYSCS_UTIL", "SYSIBM"};
    private final ParsedArgs _parsedArgs;
    private final ArrayList<SQLRoutine> _procedures = new ArrayList();
    private final ArrayList<SQLRoutine> _functions = new ArrayList();
    private final boolean _debugging = false;
    private static LocalizedResource _messageFormatter;

    private SignatureChecker(ParsedArgs parsedArgs) {
        this._parsedArgs = parsedArgs;
    }

    public static void main(String[] stringArray) {
        ParsedArgs parsedArgs = new ParsedArgs(stringArray);
        if (!parsedArgs.isValid()) {
            SignatureChecker.printUsage();
            System.exit(1);
        } else {
            SignatureChecker signatureChecker = new SignatureChecker(parsedArgs);
            signatureChecker.execute();
        }
    }

    private void execute() {
        try {
            Connection connection = this.getJ2SEConnection();
            if (connection == null) {
                SignatureChecker.println(SignatureChecker.formatMessage("SC_NO_CONN", new Object[0]));
            } else {
                this.matchSignatures(connection);
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            SignatureChecker.printThrowable(sQLException);
        }
    }

    private void matchSignatures(Connection connection) throws SQLException {
        this.matchProcedures(connection);
        this.matchFunctions(connection);
    }

    private void matchProcedures(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.findProcedures(databaseMetaData);
        this.countProcedureArgs(databaseMetaData);
        int n = this._procedures.size();
        for (int i = 0; i < n; ++i) {
            SQLRoutine sQLRoutine = this.getProcedure(i);
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = sQLRoutine.getArgCount();
            stringBuilder.append("call ");
            stringBuilder.append(sQLRoutine.getQualifiedName());
            stringBuilder.append("( ");
            for (int j = 0; j < n2; ++j) {
                if (j > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(" ? ");
            }
            stringBuilder.append(" )");
            this.checkSignature(connection, stringBuilder.toString(), this.makeReadableSignature(sQLRoutine));
        }
    }

    private void matchFunctions(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.findFunctions(databaseMetaData);
        this.countFunctionArgs(databaseMetaData);
        int n = this._functions.size();
        for (int i = 0; i < n; ++i) {
            SQLRoutine sQLRoutine = this.getFunction(i);
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = sQLRoutine.getArgCount();
            if (sQLRoutine.isTableFunction()) {
                stringBuilder.append("select * from table( ");
            } else {
                stringBuilder.append("values(  ");
            }
            stringBuilder.append(sQLRoutine.getQualifiedName());
            stringBuilder.append("( ");
            for (int j = 0; j < n2; ++j) {
                if (j > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(" ? ");
            }
            stringBuilder.append(" ) )");
            if (sQLRoutine.isTableFunction()) {
                stringBuilder.append(" s");
            }
            this.checkSignature(connection, stringBuilder.toString(), this.makeReadableSignature(sQLRoutine));
        }
    }

    private String makeReadableSignature(SQLRoutine sQLRoutine) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = sQLRoutine.getArgCount();
        stringBuilder.append(sQLRoutine.getQualifiedName());
        stringBuilder.append("( ");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(" ");
            stringBuilder.append(sQLRoutine.getArgType(i));
            stringBuilder.append(" ");
        }
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    private void findProcedures(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = databaseMetaData.getProcedures(null, null, WILDCARD);
        while (resultSet.next()) {
            String string = resultSet.getString(2);
            String string2 = resultSet.getString(3);
            if (this.isSystemSchema(string)) continue;
            this.putProcedure(string, string2);
        }
        resultSet.close();
    }

    private void countProcedureArgs(DatabaseMetaData databaseMetaData) throws SQLException {
        int n = this._procedures.size();
        for (int i = 0; i < n; ++i) {
            SQLRoutine sQLRoutine = this.getProcedure(i);
            ResultSet resultSet = databaseMetaData.getProcedureColumns(null, sQLRoutine.getSchema(), sQLRoutine.getName(), WILDCARD);
            while (resultSet.next()) {
                sQLRoutine.addArg(resultSet.getString(7));
            }
            resultSet.close();
        }
    }

    private void findFunctions(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            ResultSet resultSet = databaseMetaData.getFunctions(null, null, WILDCARD);
            while (resultSet.next()) {
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                short s2 = resultSet.getShort(5);
                if (this.isSystemSchema(string)) continue;
                boolean bl = s2 == 2;
                this.putFunction(string, string2, bl);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new SQLException(sQLException.getMessage());
        }
    }

    private void countFunctionArgs(DatabaseMetaData databaseMetaData) throws SQLException {
        int n = this._functions.size();
        for (int i = 0; i < n; ++i) {
            SQLRoutine sQLRoutine = this.getFunction(i);
            ResultSet resultSet = databaseMetaData.getFunctionColumns(null, sQLRoutine.getSchema(), sQLRoutine.getName(), WILDCARD);
            while (resultSet.next()) {
                short s2 = resultSet.getShort(5);
                if (s2 == 4 || s2 == 5) continue;
                sQLRoutine.addArg(resultSet.getString(7));
            }
            resultSet.close();
        }
    }

    private void checkSignature(Connection connection, String string, String string2) {
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection, string);
            preparedStatement.close();
            SignatureChecker.println(SignatureChecker.formatMessage("SC_FOUND_MATCH", string2));
        }
        catch (SQLException sQLException) {
            SignatureChecker.println(SignatureChecker.formatMessage("SC_UNRESOLVABLE", string2, sQLException.getMessage()));
        }
    }

    private Connection getJ2SEConnection() throws SQLException {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            Class.forName("org.apache.derby.jdbc.ClientDriver");
            Class.forName("java.sql.DriverManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            return DriverManager.getConnection(this._parsedArgs.getJ2seConnectionUrl());
        }
        catch (SQLException sQLException) {
            SignatureChecker.printThrowable(sQLException);
            return null;
        }
    }

    private PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string);
    }

    private static void printUsage() {
        SignatureChecker.println(SignatureChecker.formatMessage("SC_USAGE", new Object[0]));
    }

    private static void printThrowable(Throwable throwable) {
        throwable.printStackTrace();
    }

    private static void println(String string) {
        System.out.println(string);
    }

    private boolean isSystemSchema(String string) {
        int n = SYSTEM_SCHEMAS.length;
        for (int i = 0; i < n; ++i) {
            if (!SYSTEM_SCHEMAS[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private void putProcedure(String string, String string2) {
        this._procedures.add(new SQLRoutine(string, string2, false));
    }

    private SQLRoutine getProcedure(int n) {
        return this._procedures.get(n);
    }

    private void putFunction(String string, String string2, boolean bl) {
        this._functions.add(new SQLRoutine(string, string2, bl));
    }

    private SQLRoutine getFunction(int n) {
        return this._functions.get(n);
    }

    private static String formatMessage(String string, Object ... objectArray) {
        return SignatureChecker.getMessageFormatter().getTextMessage(string, objectArray);
    }

    private static LocalizedResource getMessageFormatter() {
        if (_messageFormatter == null) {
            _messageFormatter = LocalizedResource.getInstance();
        }
        return _messageFormatter;
    }

    class SQLRoutine {
        private final String _schema;
        private final String _name;
        private final boolean _isTableFunction;
        private final ArrayList<String> _argList = new ArrayList();

        public SQLRoutine(String string, String string2, boolean bl) {
            this._schema = string;
            this._name = string2;
            this._isTableFunction = bl;
        }

        public void addArg(String string) {
            this._argList.add(string);
        }

        public String getSchema() {
            return this._schema;
        }

        public String getName() {
            return this._name;
        }

        public int getArgCount() {
            return this._argList.size();
        }

        public String getArgType(int n) {
            return this._argList.get(n);
        }

        public boolean isTableFunction() {
            return this._isTableFunction;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SQLRoutine( ");
            stringBuilder.append(this._schema);
            stringBuilder.append(", ");
            stringBuilder.append(this._name);
            stringBuilder.append(", ");
            stringBuilder.append("isTableFunction = ");
            stringBuilder.append(this._isTableFunction);
            stringBuilder.append(", ");
            stringBuilder.append(" argCount = ");
            stringBuilder.append(this.getArgCount());
            stringBuilder.append(" )");
            return stringBuilder.toString();
        }

        private String doubleQuote(String string) {
            return "\"" + string + "\"";
        }

        public String getQualifiedName() {
            return this.doubleQuote(this._schema) + "." + this.doubleQuote(this._name);
        }
    }

    static class ParsedArgs {
        private boolean _isValid = false;
        private String _j2seConnectionUrl;

        public ParsedArgs(String[] stringArray) {
            this.parseArgs(stringArray);
        }

        public boolean isValid() {
            return this._isValid;
        }

        public String getJ2seConnectionUrl() {
            return this._j2seConnectionUrl;
        }

        private void parseArgs(String[] stringArray) {
            if (stringArray == null) {
                return;
            }
            if (stringArray.length != 1) {
                return;
            }
            this._j2seConnectionUrl = stringArray[0];
            this._isValid = true;
        }
    }
}

