/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.jena.util.iterator.NiceIterator;

public class SparseArrayIterator<E>
extends NiceIterator<E>
implements Iterator<E> {
    private final E[] entries;
    private final Runnable checkForConcurrentModification;
    private int pos;
    private boolean hasNext = false;

    public SparseArrayIterator(E[] entries, Runnable checkForConcurrentModification) {
        this.entries = entries;
        this.pos = entries.length - 1;
        this.checkForConcurrentModification = checkForConcurrentModification;
    }

    public SparseArrayIterator(E[] entries, int toIndexExclusive, Runnable checkForConcurrentModification) {
        this.entries = entries;
        this.pos = toIndexExclusive - 1;
        this.checkForConcurrentModification = checkForConcurrentModification;
    }

    @Override
    public boolean hasNext() {
        while (-1 < this.pos) {
            if (null != this.entries[this.pos]) {
                this.hasNext = true;
                return true;
            }
            --this.pos;
        }
        this.hasNext = false;
        return false;
    }

    @Override
    public E next() {
        this.checkForConcurrentModification.run();
        if (this.hasNext || this.hasNext()) {
            this.hasNext = false;
            return this.entries[this.pos--];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        while (-1 < this.pos) {
            if (null != this.entries[this.pos]) {
                action.accept(this.entries[this.pos]);
            }
            --this.pos;
        }
        this.checkForConcurrentModification.run();
    }
}

