/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceRequiredException;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.apache.jena.shared.JenaException;

public abstract class StatementBase {
    protected final ModelCom model;

    protected StatementBase(ModelCom model) {
        if (model == null) {
            throw new JenaException("Statement models must no be null");
        }
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    protected abstract StatementImpl replace(RDFNode var1);

    public abstract Literal getLiteral();

    public abstract Resource getResource();

    public abstract Resource getSubject();

    public abstract Property getPredicate();

    public abstract RDFNode getObject();

    @Deprecated
    protected StatementImpl stringReplace(String s2, String lang, boolean wellFormed) {
        return this.replace(new LiteralImpl(NodeFactory.createLiteral(s2, lang, wellFormed), this.model));
    }

    protected StatementImpl stringReplace(String s2) {
        return this.stringReplace(s2, "", false);
    }

    public Statement changeLiteralObject(boolean o) {
        return this.changeObject(this.model.createTypedLiteral(o));
    }

    public Statement changeLiteralObject(long o) {
        return this.changeObject(this.model.createTypedLiteral(o));
    }

    public Statement changeLiteralObject(char o) {
        return this.changeObject(this.model.createTypedLiteral(o));
    }

    public Statement changeLiteralObject(double o) {
        return this.changeObject(this.model.createTypedLiteral(o));
    }

    public Statement changeLiteralObject(float o) {
        return this.changeObject(this.model.createTypedLiteral(o));
    }

    public Statement changeLiteralObject(int o) {
        return this.changeObject(this.model.createTypedLiteral(o));
    }

    public Statement changeObject(String o) {
        return this.stringReplace(String.valueOf(o));
    }

    @Deprecated
    public Statement changeObject(String o, boolean wellFormed) {
        return this.stringReplace(String.valueOf(o), "", wellFormed);
    }

    public Statement changeObject(String o, String l) {
        return this.stringReplace(String.valueOf(o), l, false);
    }

    @Deprecated
    public Statement changeObject(String o, String l, boolean wellFormed) {
        return this.stringReplace(String.valueOf(o), l, wellFormed);
    }

    public Statement changeObject(RDFNode o) {
        return this.replace(o);
    }

    public boolean getBoolean() {
        return this.getLiteral().getBoolean();
    }

    public byte getByte() {
        return this.getLiteral().getByte();
    }

    public short getShort() {
        return this.getLiteral().getShort();
    }

    public int getInt() {
        return this.getLiteral().getInt();
    }

    public long getLong() {
        return this.getLiteral().getLong();
    }

    public char getChar() {
        return this.getLiteral().getChar();
    }

    public float getFloat() {
        return this.getLiteral().getFloat();
    }

    public double getDouble() {
        return this.getLiteral().getDouble();
    }

    public String getString() {
        return this.getLiteral().getLexicalForm();
    }

    protected Resource mustBeResource(RDFNode n) {
        if (n instanceof Resource) {
            return (Resource)n;
        }
        throw new ResourceRequiredException(n);
    }

    public String getLanguage() {
        return this.getLiteral().getLanguage();
    }

    @Deprecated
    public boolean getWellFormed() {
        return this.hasWellFormedXML();
    }

    @Deprecated
    public boolean hasWellFormedXML() {
        return this.getLiteral().isWellFormedXML();
    }

    public String toString() {
        return "[" + this.getSubject().toString() + ", " + this.getPredicate().toString() + ", " + this.objectString(this.getObject()) + "]";
    }

    protected String objectString(RDFNode object) {
        return object.asNode().toString(null, true);
    }
}

