/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.DerivedGridCoverage;
import org.apache.sis.coverage.grid.EvaluatorWrapper;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class ConvertedGridCoverage
extends DerivedGridCoverage {
    private final MathTransform1D[] converters;
    private final boolean isConverted;
    private final DataType bandType;
    private final ImageProcessor processor;
    private final boolean isUSerDefined;

    ConvertedGridCoverage(GridCoverage source, List<SampleDimension> range, MathTransform1D[] converters, boolean isConverted, ImageProcessor processor, boolean isUSerDefined) {
        super(source, range);
        this.converters = converters;
        this.isConverted = isConverted;
        this.bandType = ConvertedGridCoverage.getBandType(range, isConverted, source);
        this.processor = processor;
        this.isUSerDefined = isUSerDefined;
    }

    static GridCoverage create(GridCoverage source, boolean converted) throws NoninvertibleTransformException {
        ArrayList<SampleDimension> targets;
        List<SampleDimension> sources = source.getSampleDimensions();
        MathTransform1D[] converters = ConvertedGridCoverage.converters(sources, targets = new ArrayList<SampleDimension>(sources.size()), converted);
        if (converters == null) {
            return source;
        }
        return new ConvertedGridCoverage(source, targets, converters, converted, GridCoverage.Lazy.PROCESSOR, false);
    }

    static MathTransform1D[] converters(List<SampleDimension> sources, List<SampleDimension> targets, boolean converted) throws NoninvertibleTransformException {
        int numBands = sources.size();
        MathTransform1D identity = (MathTransform1D)((Object)MathTransforms.identity(1));
        Object[] converters = new MathTransform1D[numBands];
        Arrays.fill(converters, identity);
        for (int i = 0; i < numBands; ++i) {
            SampleDimension src = sources.get(i);
            SampleDimension tgt = src.forConvertedValues(converted);
            targets.add(tgt);
            if (src == tgt) continue;
            MathTransform1D tr = src.getTransferFunction().orElse(identity);
            Optional<MathTransform1D> complete = tgt.getTransferFunction();
            if (complete.isPresent()) {
                tr = MathTransforms.concatenate(tr, complete.get().inverse());
            }
            converters[i] = tr;
        }
        for (Object converter : converters) {
            if (converter.isIdentity()) continue;
            return converters;
        }
        return null;
    }

    static DataType getBandType(List<SampleDimension> targets, boolean converted, GridCoverage source) {
        NumberRange<?> union = null;
        boolean allowsNaN = false;
        for (SampleDimension dimension : targets) {
            Optional<NumberRange<?>> c = dimension.getSampleRange();
            if (c.isPresent()) {
                NumberRange<?> range = c.get();
                if (union == null) {
                    union = range;
                } else {
                    if (union instanceof MeasurementRange) {
                        union = new NumberRange(union);
                    }
                    union = union.unionAny(range);
                }
            }
            if (allowsNaN) continue;
            allowsNaN = dimension.allowsNaN();
        }
        if (union == null) {
            return source.getBandType();
        }
        DataType type = DataType.forRange(union, !converted);
        if (allowsNaN) {
            type = type.toFloat();
        }
        return type;
    }

    @Override
    final DataType getBandType() {
        return this.bandType;
    }

    @Override
    final boolean isNotRepleacable() {
        return this.isUSerDefined;
    }

    @Override
    public GridCoverage.Evaluator evaluator() {
        return new SampleConverter();
    }

    @Override
    public RenderedImage render(GridExtent sliceExtent) {
        RenderedImage image = this.source.render(sliceExtent);
        if (image != null) {
            image = this.convert(image, this.bandType, this.converters, this.processor);
        }
        return image;
    }

    @Override
    public GridCoverage forConvertedValues(boolean converted) {
        return converted == this.isConverted ? this : this.source;
    }

    @Override
    protected final GridCoverage createConvertedValues(boolean converted) {
        return this.forConvertedValues(converted);
    }

    private final class SampleConverter
    extends EvaluatorWrapper {
        SampleConverter() {
            super(ConvertedGridCoverage.this.source.evaluator());
        }

        @Override
        public GridCoverage getCoverage() {
            return ConvertedGridCoverage.this;
        }

        @Override
        public double[] apply(DirectPosition point) throws CannotEvaluateException {
            double[] values = super.apply(point);
            if (values != null) {
                try {
                    MathTransform1D[] converters = ConvertedGridCoverage.this.converters;
                    for (int i = 0; i < converters.length; ++i) {
                        values[i] = converters[i].transform(values[i]);
                    }
                }
                catch (TransformException ex) {
                    throw new CannotEvaluateException(ex.getMessage(), ex);
                }
            }
            return values;
        }
    }
}

