/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.opengis.feature.FeatureType;

final class CommonParentFinder {
    private final Map<FeatureType, Boolean> allTypes;
    private final FeatureType[] required;
    private final int count;

    static FeatureType select(Iterable<? extends FeatureType> types) {
        LinkedHashMap<FeatureType, Boolean> allTypes = new LinkedHashMap<FeatureType, Boolean>();
        types.forEach(type -> allTypes.putIfAbsent((FeatureType)type, Boolean.FALSE));
        allTypes.remove(null);
        int count = allTypes.size();
        FeatureType[] required = allTypes.keySet().toArray(new FeatureType[count]);
        for (int i = 0; i < count; ++i) {
            FeatureType parent = required[i];
            int j = count;
            while (--j >= 0) {
                if (j == i || !parent.isAssignableFrom(required[j])) continue;
                System.arraycopy(required, j + 1, required, j, --count - j);
                required[count] = null;
                if (j >= i) continue;
                --i;
            }
        }
        switch (count) {
            case 0: {
                return null;
            }
            case 1: {
                return required[0];
            }
        }
        return new CommonParentFinder(allTypes, required, count).select();
    }

    private CommonParentFinder(Map<FeatureType, Boolean> allTypes, FeatureType[] required, int count) {
        this.allTypes = allTypes;
        this.required = required;
        this.count = count;
        for (int i = 0; i < count; ++i) {
            this.scanParents(required[i]);
        }
    }

    private boolean isAssignableFromAll(FeatureType parent) {
        for (int i = 0; i < this.count; ++i) {
            FeatureType type = this.required[i];
            if (type == parent || parent.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    private void scanParents(FeatureType type) {
        for (FeatureType featureType : type.getSuperTypes()) {
            if (this.allTypes.putIfAbsent(featureType, Boolean.FALSE) != null) continue;
            if (this.isAssignableFromAll(featureType)) {
                this.allTypes.put(featureType, Boolean.TRUE);
                this.skipParents(featureType);
                continue;
            }
            this.scanParents(featureType);
        }
    }

    private void skipParents(FeatureType type) {
        assert (this.isAssignableFromAll(type));
        for (FeatureType featureType : type.getSuperTypes()) {
            if (Boolean.TRUE.equals(this.allTypes.put(featureType, Boolean.FALSE))) continue;
            this.skipParents(featureType);
        }
    }

    FeatureType select() {
        this.allTypes.values().removeIf(Predicate.isEqual(Boolean.FALSE));
        FeatureType best = null;
        int numProperties = 0;
        for (FeatureType type : this.allTypes.keySet()) {
            int n = type.getProperties(true).size();
            if (best != null && n <= numProperties) continue;
            best = type;
            numProperties = n;
        }
        return best;
    }
}

