/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.CharacteristicTypeMap;
import org.apache.sis.feature.FieldType;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.opengis.feature.Attribute;
import org.opengis.feature.AttributeType;

public class DefaultAttributeType<V>
extends FieldType
implements AttributeType<V> {
    private static final long serialVersionUID = -817024213677735239L;
    private final Class<V> valueClass;
    private final V defaultValue;
    private transient CharacteristicTypeMap characteristics;

    public DefaultAttributeType(Map<String, ?> identification, Class<V> valueClass, int minimumOccurs, int maximumOccurs, V defaultValue, AttributeType<?> ... characterizedBy) {
        super(identification, minimumOccurs, maximumOccurs);
        ArgumentChecks.ensureNonNull("valueClass", valueClass);
        ArgumentChecks.ensureCanCast("defaultValue", valueClass, defaultValue);
        this.valueClass = valueClass;
        this.defaultValue = Numerics.cached(defaultValue);
        if (characterizedBy != null && characterizedBy.length != 0) {
            this.characteristics = CharacteristicTypeMap.create(this, (AttributeType[])characterizedBy.clone());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.characteristics != null ? this.characteristics.characterizedBy : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            AttributeType[] characterizedBy = (AttributeType[])in.readObject();
            if (characterizedBy != null) {
                this.characteristics = CharacteristicTypeMap.create(this, characterizedBy);
            }
        }
        catch (RuntimeException e) {
            throw (IOException)new InvalidObjectException(e.getLocalizedMessage()).initCause(e);
        }
    }

    @Override
    public final Class<V> getValueClass() {
        return this.valueClass;
    }

    @Override
    public final int getMinimumOccurs() {
        return super.getMinimumOccurs();
    }

    @Override
    public final int getMaximumOccurs() {
        return super.getMaximumOccurs();
    }

    @Override
    public V getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Map<String, AttributeType<?>> characteristics() {
        return this.characteristics != null ? this.characteristics : Collections.emptyMap();
    }

    @Override
    public Attribute<V> newInstance() {
        return AbstractAttribute.create(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.valueClass.hashCode() + Objects.hashCode(this.defaultValue) + Objects.hashCode(this.characteristics);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (super.equals(obj)) {
            DefaultAttributeType that = (DefaultAttributeType)obj;
            return this.valueClass == that.valueClass && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.characteristics, that.characteristics);
        }
        return false;
    }

    public String toString() {
        return DefaultAttributeType.toString(this.deprecated, "AttributeType", this.getName(), Classes.getShortName(this.valueClass)).toString();
    }
}

