/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.OperationResult;
import org.apache.sis.internal.feature.FeatureUtilities;
import org.apache.sis.internal.filter.Visitor;
import org.opengis.feature.AttributeType;
import org.opengis.feature.Feature;
import org.opengis.feature.IdentifiedType;
import org.opengis.feature.Property;
import org.opengis.filter.Expression;
import org.opengis.filter.Filter;
import org.opengis.filter.LogicalOperator;
import org.opengis.filter.ValueReference;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.CodeList;

final class ExpressionOperation<V>
extends AbstractOperation {
    private static final long serialVersionUID = 5411697964136428848L;
    private static final ParameterDescriptorGroup PARAMETERS = FeatureUtilities.parameters("Expression", new ParameterDescriptor[0]);
    private final Function<? super Feature, ? extends V> expression;
    private final AttributeType<V> resultType;
    private final Set<String> dependencies;

    static <V> AbstractOperation create(Map<String, ?> identification, Function<? super Feature, ? extends V> expression, AttributeType<? super V> resultType) {
        String xpath;
        if (expression instanceof ValueReference && (xpath = ((ValueReference)expression).getXPath()).equals(resultType.getName().toString())) {
            return new LinkOperation(identification, resultType);
        }
        return new ExpressionOperation<V>(identification, expression, resultType);
    }

    private ExpressionOperation(Map<String, ?> identification, Function<? super Feature, ? extends V> expression, AttributeType<V> resultType) {
        super(identification);
        this.expression = expression;
        this.resultType = resultType;
        if (expression instanceof Expression) {
            Expression c = (Expression)expression;
            this.dependencies = DependencyFinder.search(c);
        } else {
            this.dependencies = Set.of();
        }
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return PARAMETERS;
    }

    @Override
    public IdentifiedType getResult() {
        return this.resultType;
    }

    @Override
    public Set<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Property apply(Feature feature, ParameterValueGroup parameters) {
        return new Result(feature);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.expression.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.expression.equals(((ExpressionOperation)obj).expression);
    }

    private static final class DependencyFinder
    extends Visitor<Feature, Collection<String>> {
        private static final DependencyFinder VISITOR = new DependencyFinder();

        static Set<String> search(Expression<Feature, ?> expression) {
            HashSet dependencies = new HashSet();
            VISITOR.visit(expression, dependencies);
            return Set.copyOf(dependencies);
        }

        private DependencyFinder() {
            this.setLogicalHandlers((f, dependencies) -> {
                LogicalOperator filter = (LogicalOperator)f;
                for (Filter child : filter.getOperands()) {
                    this.visit(child, dependencies);
                }
            });
            this.setExpressionHandler("ValueReference", (e, dependencies) -> {
                ValueReference expression = (ValueReference)e;
                String propName = expression.getXPath();
                if (!propName.trim().isEmpty()) {
                    dependencies.add(propName);
                }
            });
        }

        @Override
        protected void typeNotFound(CodeList<?> type, Filter<Feature> filter, Collection<String> dependencies) {
            for (Expression<Feature, ?> f : filter.getExpressions()) {
                this.visit(f, dependencies);
            }
        }

        @Override
        protected void typeNotFound(String type, Expression<Feature, ?> expression, Collection<String> dependencies) {
            for (Expression<Feature, ?> p : expression.getParameters()) {
                this.visit(p, dependencies);
            }
        }
    }

    private final class Result
    extends OperationResult<V> {
        private static final long serialVersionUID = -19004252522001532L;

        Result(Feature feature) {
            super(ExpressionOperation.this.resultType, feature);
        }

        @Override
        public V getValue() {
            return ExpressionOperation.this.expression.apply(this.feature);
        }
    }
}

