/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Field;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.feature.Attribute;
import org.opengis.feature.AttributeType;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureAssociationRole;
import org.opengis.feature.FeatureType;
import org.opengis.feature.IdentifiedType;
import org.opengis.feature.Operation;
import org.opengis.feature.PropertyType;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class FeatureFormat
extends TabularFormat<Object> {
    private static final long serialVersionUID = -5792086817264884947L;
    private static final String SEPARATOR = ", ";
    private static final AtomicReference<FeatureFormat> INSTANCE = new AtomicReference();
    private final Locale displayLocale;
    private final EnumSet<Column> columns = EnumSet.allOf(Column.class);
    private static final int MAXIMAL_VALUE_LENGTH = 40;
    private transient int illegalNaN;

    public FeatureFormat() {
        super(Locale.getDefault(Locale.Category.FORMAT), TimeZone.getDefault());
        this.displayLocale = Locale.getDefault(Locale.Category.DISPLAY);
        this.columnSeparator = " \u2502 ";
    }

    public FeatureFormat(Locale locale, TimeZone timezone) {
        super(locale, timezone);
        this.displayLocale = locale != null ? locale : Locale.ROOT;
        this.columnSeparator = " \u2502 ";
    }

    @Override
    public final Class<Object> getValueType() {
        return Object.class;
    }

    @Override
    public Locale getLocale(Locale.Category category) {
        return category == Locale.Category.DISPLAY ? this.displayLocale : super.getLocale(category);
    }

    public Set<Column> getAllowedColumns() {
        return this.columns.clone();
    }

    public void setAllowedColumns(Set<Column> inclusion) {
        ArgumentChecks.ensureNonNull("inclusion", inclusion);
        this.columns.clear();
        this.columns.addAll(inclusion);
    }

    private void nextColumn(TableAppender table) {
        table.append(this.beforeFill);
        table.nextColumn(this.fillCharacter);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void format(Object object, Appendable toAppendTo) throws IOException {
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("toAppendTo", toAppendTo);
        if (object instanceof Feature) {
            feature = (Feature)object;
            featureType = feature.getType();
        } else if (object instanceof FeatureType) {
            featureType = (FeatureType)object;
            feature = null;
        } else {
            throw new IllegalArgumentException(Errors.getResources(this.displayLocale).getString((short)163, object.getClass()));
        }
        visibleColumns = this.columns.clone();
        hasDesignation = false;
        hasCharacteristics = false;
        hasDeprecatedTypes = false;
        for (PropertyType propertyType : featureType.getProperties(true)) {
            if (!hasDesignation) {
                v0 = hasDesignation = propertyType.getDesignation() != null;
            }
            if (!hasCharacteristics && propertyType instanceof AttributeType) {
                v1 = hasCharacteristics = ((AttributeType)propertyType).characteristics().isEmpty() == false;
            }
            if (hasDeprecatedTypes || !(propertyType instanceof Deprecable)) continue;
            hasDeprecatedTypes = ((Deprecable)propertyType).isDeprecated();
        }
        if (!hasDesignation) {
            visibleColumns.remove((Object)Column.DESIGNATION);
        }
        if (!hasCharacteristics) {
            visibleColumns.remove((Object)Column.CHARACTERISTICS);
        }
        if (!hasDeprecatedTypes) {
            visibleColumns.remove((Object)Column.REMARKS);
        }
        toAppendTo.append(this.toString(featureType.getName()));
        if (feature == null) {
            separator = " \u21fe ";
            for (FeatureType parent : featureType.getSuperTypes()) {
                toAppendTo.append(separator).append(this.toString(parent.getName()));
                separator = ", ";
            }
            definition = featureType.getDefinition();
            if (definition != null && (text = Strings.trimOrNull(definition.toString(this.displayLocale))) != null) {
                toAppendTo.append(this.getLineSeparator()).append(text);
            }
        }
        toAppendTo.append(this.getLineSeparator());
        resources = Vocabulary.getResources(this.displayLocale);
        table = new TableAppender(toAppendTo, this.columnSeparator);
        table.setMultiLinesCells(true);
        table.nextLine('\u2500');
        isFirstColumn = true;
        var9_15 = visibleColumns.iterator();
        while (var9_15.hasNext()) {
            column = (Column)var9_15.next();
            key = column.resourceKey;
            if (feature == null) {
                if (key == 20) {
                    key = 138;
                }
                if (key == 213) {
                    key = 56;
                }
            }
            if (!isFirstColumn) {
                this.nextColumn(table);
            }
            table.append(resources.getString((short)key));
            isFirstColumn = false;
        }
        table.nextLine();
        table.nextLine('\u2500');
        buffer = new StringBuffer();
        dummyFP = new FieldPosition(-1);
        remarks = new ArrayList<String>();
        for (PropertyType propertyType : featureType.getProperties(true)) {
            value = null;
            cardinality = -1;
            if (feature != null) {
                if (!(propertyType instanceof AttributeType) && !(propertyType instanceof FeatureAssociationRole) && !DefaultFeatureType.isParameterlessOperation(propertyType)) continue;
                value = feature.getPropertyValue(propertyType.getName().toString());
                if (value == null) {
                    if (propertyType instanceof AttributeType && ((AttributeType)propertyType).getMinimumOccurs() == 0 && ((AttributeType)propertyType).characteristics().isEmpty() || propertyType instanceof FeatureAssociationRole && ((FeatureAssociationRole)propertyType).getMinimumOccurs() == 0) continue;
                    cardinality = 0;
                } else {
                    cardinality = value instanceof Collection ? ((Collection)value).size() : 1;
                }
            } else if (propertyType instanceof AttributeType) {
                value = ((AttributeType)propertyType).getDefaultValue();
            } else if (propertyType instanceof Operation) {
                buffer.append(" = ");
                try {
                    if (propertyType instanceof AbstractOperation) {
                        ((AbstractOperation)propertyType).formatResultFormula(buffer);
                    } else {
                        AbstractOperation.defaultFormula(((Operation)propertyType).getParameters(), buffer);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                value = CharSequences.trimWhitespaces(buffer).toString();
                buffer.setLength(0);
            }
            resultType = propertyType instanceof Operation != false ? ((Operation)propertyType).getResult() : propertyType;
            if (resultType instanceof AttributeType) {
                pt = (AttributeType)resultType;
                minimumOccurs = pt.getMinimumOccurs();
                maximumOccurs = pt.getMaximumOccurs();
                valueClass = pt.getValueClass();
                valueType = this.getFormat(Class.class).format(valueClass, buffer, dummyFP).toString();
                buffer.setLength(0);
            } else if (resultType instanceof FeatureAssociationRole) {
                pt = (FeatureAssociationRole)resultType;
                minimumOccurs = pt.getMinimumOccurs();
                maximumOccurs = pt.getMaximumOccurs();
                valueType = this.toString(DefaultAssociationRole.getValueTypeName((FeatureAssociationRole)pt));
                valueClass = Feature.class;
            } else {
                valueType = resultType != null ? this.toString(resultType.getName()) : "";
                valueClass = null;
                minimumOccurs = -1;
                maximumOccurs = -1;
            }
            isFirstColumn = true;
            var21_31 = visibleColumns.iterator();
            block17: while (var21_31.hasNext()) {
                column = (Column)var21_31.next();
                if (!isFirstColumn) {
                    this.nextColumn(table);
                }
                isFirstColumn = false;
                block2 : switch (1.$SwitchMap$org$apache$sis$feature$FeatureFormat$Column[column.ordinal()]) {
                    case 1: {
                        d = propertyType.getDesignation();
                        if (d == null) break;
                        table.append(d.toString(this.displayLocale));
                        break;
                    }
                    case 2: {
                        table.append(this.toString(propertyType.getName()));
                        break;
                    }
                    case 3: {
                        table.append(valueType);
                        break;
                    }
                    case 4: {
                        table.setCellAlignment((byte)1);
                        if (cardinality >= 0) {
                            table.append(this.getFormat(Integer.class).format(cardinality, buffer, dummyFP));
                            buffer.setLength(0);
                        }
                        if (maximumOccurs < 0) break;
                        if (cardinality >= 0) {
                            table.append(' ').append((char)(cardinality >= minimumOccurs && cardinality <= maximumOccurs ? 8712 : 8713)).append(' ');
                        }
                        format = this.getFormat(Integer.class);
                        table.append('[').append(format.format(minimumOccurs, buffer, dummyFP)).append(" \u2026 ");
                        buffer.setLength(0);
                        if (maximumOccurs != 0x7FFFFFFF) {
                            table.append(format.format(maximumOccurs, buffer, dummyFP));
                        } else {
                            table.append('\u221e');
                        }
                        buffer.setLength(0);
                        table.append(']');
                        break;
                    }
                    case 5: {
                        table.setCellAlignment((byte)-1);
                        format = this.getFormat(valueClass);
                        it = CollectionsExt.toCollection(value).iterator();
                        separator = "";
                        length = 0;
                        while (it.hasNext()) {
                            value = it.next();
                            if (value == null) continue;
                            if (!(propertyType instanceof FeatureAssociationRole)) ** GOTO lbl181
                            p = DefaultAssociationRole.getTitleProperty((FeatureAssociationRole)propertyType);
                            if (p != null && (value = ((Feature)value).getPropertyValue(p)) == null) {
                                continue;
                            }
                            ** GOTO lbl201
lbl181:
                            // 1 sources

                            if (format == null || !valueClass.isInstance(value)) ** GOTO lbl201
                            t = format.format(value, buffer, dummyFP);
                            if (!(value instanceof Number) || !Float.isNaN(f = ((Number)value).floatValue())) ** GOTO lbl200
                            if ("\ufffd".contentEquals(t)) {
                                t.setLength(0);
                                t.append("NaN");
                            }
                            try {
                                n = MathFunctions.toNanOrdinal(f);
                                if (n > 0) {
                                    t.append(" #").append(n);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                bits = Float.floatToRawIntBits(f);
                                if (bits == this.illegalNaN) ** GOTO lbl200
                                this.illegalNaN = bits;
                                Logging.recoverableException(AbstractIdentifiedType.LOGGER, FeatureFormat.class, "format", e);
                            }
lbl200:
                            // 4 sources

                            value = t;
lbl201:
                            // 3 sources

                            length = this.formatValue(value, table.append(separator), length);
                            buffer.setLength(0);
                            if (length < 0) break block2;
                            separator = ", ";
                            length += ", ".length();
                        }
                        break;
                    }
                    case 6: {
                        if (!(propertyType instanceof AttributeType)) break;
                        length = 0;
                        separator = "";
                        for (AttributeType<?> ct : ((AttributeType)propertyType).characteristics().values()) {
                            cn = ct.getName();
                            cs = this.toString(cn);
                            table.append(separator).append(cs);
                            length += separator.length() + cs.length();
                            cv /* !! */  = CollectionsExt.singletonOrEmpty(ct.getDefaultValue());
                            if (feature != null && (cp = feature.getProperty(propertyType.getName().toString())) instanceof Attribute && (ca = ((Attribute)cp).characteristics().get(cn.toString())) != null) {
                                cv /* !! */  = ca.getValues();
                            }
                            multi = ct.getMaximumOccurs() > 1;
                            sep = multi != false ? " = {" : " = ";
                            for (E c : cv /* !! */ ) {
                                length += sep.length();
                                length = this.formatValue(c, table.append(sep), length);
                                if (length < 0) break block2;
                                sep = ", ";
                            }
                            separator = ", ";
                            if (!multi || sep != ", ") continue;
                            table.append('}');
                        }
                        continue block17;
                    }
                    case 7: {
                        if (!Field.isDeprecated(propertyType)) break;
                        table.append(resources.getString((short)57));
                        r = ((Deprecable)propertyType).getRemarks();
                        if (r == null) break;
                        remarks.add(r.toString(this.displayLocale));
                        FeatureFormat.appendSuperscript(remarks.size(), table);
                    }
                }
            }
            table.nextLine();
        }
        table.nextLine('\u2500');
        table.flush();
        n = remarks.size();
        for (i = 0; i < n; ++i) {
            FeatureFormat.appendSuperscript(i + 1, toAppendTo);
            toAppendTo.append(' ').append((CharSequence)remarks.get(i)).append(this.lineSeparator);
        }
    }

    private String toString(GenericName name) {
        String s2;
        if (name == null) {
            return "";
        }
        InternationalString i18n = name.toInternationalString();
        if (i18n != null && (s2 = i18n.toString(this.displayLocale)) != null) {
            return s2;
        }
        return name.toString();
    }

    private int formatValue(Object value, TableAppender table, int length) {
        int remaining = 40 - length;
        String text = value instanceof InternationalString ? ((InternationalString)value).toString(this.displayLocale) : (value instanceof GenericName ? this.toString((GenericName)value) : (value instanceof IdentifiedType ? this.toString(((IdentifiedType)value).getName()) : (value instanceof IdentifiedObject ? IdentifiedObjects.getIdentifierOrName((IdentifiedObject)value) : Geometries.wrap(value).map(GeometryWrapper::toString).orElseGet(value::toString))));
        if (remaining >= text.length()) {
            table.append(text);
            return length + text.length();
        }
        table.append(text, 0, Math.max(0, remaining - 1)).append('\u2026');
        return -1;
    }

    private static void appendSuperscript(int n, Appendable toAppendTo) throws IOException {
        if (n >= 0 && n < 10) {
            toAppendTo.append(Characters.toSuperScript((char)(48 + n)));
        } else {
            toAppendTo.append('(').append(String.valueOf(n)).append(')');
        }
    }

    static String sharedFormat(Object object) {
        FeatureFormat f = INSTANCE.getAndSet(null);
        if (f == null) {
            f = new FeatureFormat();
        }
        String s2 = f.format(object);
        INSTANCE.set(f);
        return s2;
    }

    @Override
    public Object parse(CharSequence text, ParsePosition pos) throws ParseException {
        throw new ParseException(Errors.getResources(this.displayLocale).getString((short)162, "parse"), pos.getIndex());
    }

    @Override
    public FeatureFormat clone() {
        return (FeatureFormat)super.clone();
    }

    public static enum Column {
        DESIGNATION(60),
        NAME(139),
        TYPE(203),
        CARDINALITY(20),
        VALUE(213),
        CHARACTERISTICS(26),
        REMARKS(169);

        final short resourceKey;

        private Column(short key) {
            this.resourceKey = key;
        }
    }
}

