/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Map;
import java.util.function.Function;
import org.apache.sis.feature.EnvelopeOperation;
import org.apache.sis.feature.ExpressionOperation;
import org.apache.sis.feature.GroupAsPolylineOperation;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.StringJoinOperation;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.resources.Errors;
import org.opengis.feature.AttributeType;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureAssociationRole;
import org.opengis.feature.Operation;
import org.opengis.feature.PropertyType;
import org.opengis.filter.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public final class FeatureOperations
extends Static {
    static final WeakHashSet<PropertyType> POOL = new WeakHashSet<PropertyType>(PropertyType.class);

    private FeatureOperations() {
    }

    public static Operation link(Map<String, ?> identification, PropertyType referent) {
        ArgumentChecks.ensureNonNull("referent", referent);
        return POOL.unique(new LinkOperation(identification, referent));
    }

    public static Operation compound(Map<String, ?> identification, String delimiter, String prefix, String suffix, PropertyType ... singleAttributes) throws UnconvertibleObjectException {
        PropertyType at;
        ArgumentChecks.ensureNonEmpty("delimiter", delimiter);
        if (delimiter.indexOf(92) >= 0) {
            throw new IllegalArgumentException(Errors.getResources(identification).getString((short)49, "delimiter", Character.valueOf('\\')));
        }
        ArgumentChecks.ensureNonEmpty("singleAttributes", singleAttributes);
        if (!(singleAttributes.length != 1 || prefix != null && !prefix.isEmpty() || suffix != null && !suffix.isEmpty() || (at = singleAttributes[0]) instanceof FeatureAssociationRole)) {
            return FeatureOperations.link(identification, at);
        }
        return POOL.unique(new StringJoinOperation(identification, delimiter, prefix, suffix, singleAttributes));
    }

    public static Operation envelope(Map<String, ?> identification, CoordinateReferenceSystem crs, PropertyType ... geometryAttributes) throws FactoryException {
        ArgumentChecks.ensureNonNull("geometryAttributes", geometryAttributes);
        return POOL.unique(new EnvelopeOperation(identification, crs, geometryAttributes));
    }

    public static Operation groupAsPolyline(Map<String, ?> identification, GeometryLibrary library, PropertyType components) {
        ArgumentChecks.ensureNonNull("library", (Object)library);
        ArgumentChecks.ensureNonNull("components", components);
        return POOL.unique(GroupAsPolylineOperation.create(identification, library, components));
    }

    public static <V> Operation function(Map<String, ?> identification, Function<? super Feature, ? extends V> expression, AttributeType<? super V> resultType) {
        ArgumentChecks.ensureNonNull("expression", expression);
        ArgumentChecks.ensureNonNull("resultType", resultType);
        return POOL.unique(ExpressionOperation.create(identification, expression, resultType));
    }

    public static <V> Operation expression(Map<String, ?> identification, Expression<? super Feature, ?> expression, AttributeType<V> resultType) {
        return FeatureOperations.function(identification, expression.toValueType(resultType.getValueClass()), resultType);
    }
}

