/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.IdentityHashMap;
import java.util.Optional;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.CommonParentFinder;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.InvalidFeatureException;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.Validator;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.Static;
import org.apache.sis.util.iso.Names;
import org.opengis.feature.Attribute;
import org.opengis.feature.AttributeType;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureAssociationRole;
import org.opengis.feature.FeatureType;
import org.opengis.feature.IdentifiedType;
import org.opengis.feature.InvalidPropertyValueException;
import org.opengis.feature.Operation;
import org.opengis.feature.PropertyType;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.Result;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public final class Features
extends Static {
    private Features() {
    }

    public static <V> AttributeType<V> cast(AttributeType<?> type, Class<V> valueClass) throws ClassCastException {
        Class<?> actual;
        if (type != null && !valueClass.equals(actual = type.getValueClass())) {
            throw new ClassCastException(Resources.format((short)48, type.getName(), valueClass, actual));
        }
        return type;
    }

    public static <V> Attribute<V> cast(Attribute<?> attribute, Class<V> valueClass) throws ClassCastException {
        Class<?> actual;
        if (attribute != null && !valueClass.equals(actual = attribute.getType().getValueClass())) {
            throw new ClassCastException(Resources.format((short)48, attribute.getName(), valueClass, actual));
        }
        return attribute;
    }

    public static Optional<AttributeType<?>> toAttribute(IdentifiedType type) {
        return Features.toIdentifiedType(type, AttributeType.class);
    }

    public static Optional<FeatureAssociationRole> toAssociation(IdentifiedType type) {
        return Features.toIdentifiedType(type, FeatureAssociationRole.class);
    }

    private static <T> Optional<T> toIdentifiedType(IdentifiedType type, Class<T> target) {
        if (!target.isInstance(type)) {
            if (!(type instanceof Operation)) {
                return Optional.empty();
            }
            if (!target.isInstance(type = ((Operation)type).getResult())) {
                if (!(type instanceof Operation)) {
                    return Optional.empty();
                }
                IdentityHashMap<IdentifiedType, Boolean> done = new IdentityHashMap<IdentifiedType, Boolean>(4);
                while (!target.isInstance(type = ((Operation)type).getResult())) {
                    if (type instanceof Operation && done.put(type, Boolean.TRUE) == null) continue;
                    return Optional.empty();
                }
            }
        }
        return Optional.of(target.cast(type));
    }

    public static FeatureType findCommonParent(Iterable<? extends FeatureType> types) {
        return types != null ? CommonParentFinder.select(types) : null;
    }

    public static Class<?> getValueClass(PropertyType type) {
        while (type instanceof Operation) {
            IdentifiedType result = ((Operation)type).getResult();
            if (result != type && result instanceof PropertyType) {
                type = (PropertyType)result;
                continue;
            }
            if (!(result instanceof FeatureType)) break;
            return Feature.class;
        }
        if (type instanceof AttributeType) {
            return ((AttributeType)type).getValueClass();
        }
        if (type instanceof FeatureAssociationRole) {
            return Feature.class;
        }
        return null;
    }

    public static GenericName getValueTypeName(PropertyType property) {
        IdentifiedType result;
        if (property instanceof FeatureAssociationRole) {
            return DefaultAssociationRole.getValueTypeName((FeatureAssociationRole)property);
        }
        if (property instanceof AttributeType) {
            return Names.createTypeName(((AttributeType)property).getValueClass());
        }
        if (property instanceof Operation && (result = ((Operation)property).getResult()) != null) {
            return result.getName();
        }
        return null;
    }

    public static Optional<String> getLinkTarget(PropertyType property) {
        if (property instanceof LinkOperation) {
            return Optional.of(((LinkOperation)property).referentName);
        }
        return Optional.empty();
    }

    public static void validate(Feature feature) throws InvalidPropertyValueException {
        if (feature != null) {
            DataQuality quality;
            if (feature instanceof AbstractFeature) {
                quality = ((AbstractFeature)feature).quality();
            } else {
                Validator v = new Validator(ScopeCode.FEATURE);
                v.validate(feature.getType(), feature);
                quality = v.quality;
            }
            for (Element element : quality.getReports()) {
                for (Result result : element.getResults()) {
                    InternationalString message;
                    if (!(result instanceof ConformanceResult) || !Boolean.FALSE.equals(((ConformanceResult)result).pass()) || (message = ((ConformanceResult)result).getExplanation()) == null) continue;
                    throw new InvalidFeatureException(message);
                }
            }
        }
    }
}

