/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Objects;
import org.apache.sis.feature.AbstractAttribute;
import org.opengis.feature.AttributeType;

final class SingletonAttribute<V>
extends AbstractAttribute<V>
implements Cloneable {
    private static final long serialVersionUID = -2236273725166545505L;
    private V value;

    public SingletonAttribute(AttributeType<V> type) {
        super(type);
        assert (SingletonAttribute.isSingleton(type.getMaximumOccurs()));
        this.value = type.getDefaultValue();
    }

    SingletonAttribute(AttributeType<V> type, Object value) {
        super(type);
        assert (SingletonAttribute.isSingleton(type.getMaximumOccurs()));
        this.value = type.getValueClass().cast(value);
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(V value) {
        this.value = value;
    }

    public int hashCode() {
        return this.type.hashCode() + Objects.hashCode(this.value) + this.characteristicsReadOnly().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SingletonAttribute) {
            SingletonAttribute that = (SingletonAttribute)obj;
            return this.type.equals(that.type) && Objects.equals(this.value, that.value) && this.characteristicsReadOnly().equals(that.characteristicsReadOnly());
        }
        return false;
    }
}

