/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.builder;

import java.util.Objects;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.TypeBuilder;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.opengis.feature.AttributeType;
import org.opengis.util.GenericName;

public final class CharacteristicTypeBuilder<V>
extends TypeBuilder {
    private AttributeTypeBuilder<?> owner;
    private final Class<V> valueClass;
    private V defaultValue;
    private transient AttributeType<V> characteristic;

    private CharacteristicTypeBuilder(CharacteristicTypeBuilder<?> builder, Class<V> valueClass) throws UnconvertibleObjectException {
        super(builder);
        this.owner = builder.owner;
        this.valueClass = valueClass;
        this.defaultValue = ObjectConverters.convert(builder.defaultValue, valueClass);
    }

    CharacteristicTypeBuilder(AttributeTypeBuilder<?> owner, Class<V> valueClass) {
        super(owner.getLocale());
        this.owner = owner;
        this.valueClass = valueClass;
    }

    CharacteristicTypeBuilder(AttributeTypeBuilder<?> owner, AttributeType<V> template) {
        super(owner.getLocale());
        this.owner = owner;
        this.characteristic = template;
        this.valueClass = template.getValueClass();
        this.defaultValue = template.getDefaultValue();
        this.initialize(template);
    }

    @Override
    final void clearCache() {
        this.characteristic = null;
        this.ensureAlive(this.owner);
        this.owner.clearCache();
    }

    @Override
    final String getDefaultName() {
        return Classes.getShortName(this.valueClass);
    }

    @Override
    public CharacteristicTypeBuilder<V> setName(GenericName name) {
        super.setName(name);
        return this;
    }

    @Override
    public CharacteristicTypeBuilder<V> setName(CharSequence localPart) {
        super.setName(localPart);
        return this;
    }

    @Override
    public CharacteristicTypeBuilder<V> setName(CharSequence ... components) {
        super.setName(components);
        return this;
    }

    @Override
    final GenericName createLocalName(CharSequence name) {
        this.ensureAlive(this.owner);
        return this.owner.createLocalName(name);
    }

    @Override
    final GenericName createGenericName(CharSequence ... names) {
        this.ensureAlive(this.owner);
        return this.owner.createGenericName(names);
    }

    public Class<V> getValueClass() {
        return this.valueClass;
    }

    public <N> CharacteristicTypeBuilder<N> setValueClass(Class<N> type) throws UnconvertibleObjectException {
        this.ensureAlive(this.owner);
        this.ensureNonNull("type", type);
        if (type == this.valueClass) {
            return this;
        }
        CharacteristicTypeBuilder<N> newb = new CharacteristicTypeBuilder<N>(this, type);
        this.owner.characteristics.set(this.owner.characteristics.lastIndexOf(this), newb);
        this.owner = null;
        return newb;
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public CharacteristicTypeBuilder<V> setDefaultValue(V value) {
        if (!Objects.equals(this.defaultValue, value)) {
            this.defaultValue = value;
            this.clearCache();
        }
        return this;
    }

    final void set(Object value) {
        this.setDefaultValue(this.valueClass.cast(value));
    }

    @Override
    public CharacteristicTypeBuilder<V> setDefinition(CharSequence definition) {
        super.setDefinition(definition);
        return this;
    }

    @Override
    public CharacteristicTypeBuilder<V> setDesignation(CharSequence designation) {
        super.setDesignation(designation);
        return this;
    }

    @Override
    public CharacteristicTypeBuilder<V> setDescription(CharSequence description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public CharacteristicTypeBuilder<V> setDeprecated(boolean deprecated) {
        super.setDeprecated(deprecated);
        return this;
    }

    @Override
    public AttributeType<V> build() {
        if (this.characteristic == null) {
            this.characteristic = new DefaultAttributeType<V>(this.identification(), this.valueClass, 0, 1, this.defaultValue, new AttributeType[0]);
        }
        return this.characteristic;
    }

    final void owner(AttributeTypeBuilder<?> newb) {
        this.owner = newb;
    }

    @Override
    public void remove() {
        if (this.owner != null) {
            this.owner.characteristics.remove(this.owner.characteristics.lastIndexOf(this));
            this.owner.clearCache();
            this.owner = null;
        }
    }
}

