/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import org.apache.sis.filter.BinaryGeometryFilter;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.SpatialOperationContext;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.filter.BinarySpatialOperator;
import org.opengis.filter.Expression;
import org.opengis.filter.SpatialOperatorName;
import org.opengis.geometry.Envelope;

final class BinarySpatialFilter<R, G>
extends BinaryGeometryFilter<R, G>
implements BinarySpatialOperator<R> {
    private static final long serialVersionUID = -7600403345673820881L;
    private final SpatialOperatorName operatorType;

    BinarySpatialFilter(Geometries<G> library, Expression<R, ?> geometry, Envelope bounds, WraparoundMethod wraparound) {
        super(library, geometry, new LeafExpression.Transformed(library.toGeometry2D(bounds, wraparound), new LeafExpression.Literal(bounds)), null);
        this.operatorType = SpatialOperatorName.BBOX;
    }

    BinarySpatialFilter(SpatialOperatorName operatorType, Geometries<G> library, Expression<R, ?> geometry1, Expression<R, ?> geometry2) {
        super(library, geometry1, geometry2, null);
        this.operatorType = operatorType;
        ArgumentChecks.ensureNonNull("operatorType", operatorType);
    }

    @Override
    protected BinaryGeometryFilter<R, G> recreate(Expression<R, ?> geometry1, Expression<R, ?> geometry2) {
        return new BinarySpatialFilter(this.operatorType, BinarySpatialFilter.getGeometryLibrary(this.expression1), geometry1, geometry2);
    }

    @Override
    public SpatialOperatorName getOperatorType() {
        return this.operatorType;
    }

    @Override
    public Expression<R, ?> getOperand1() {
        return BinarySpatialFilter.original(this.expression1);
    }

    @Override
    public Expression<R, ?> getOperand2() {
        return BinarySpatialFilter.original(this.expression2);
    }

    @Override
    protected Collection<?> getChildren() {
        return this.getExpressions();
    }

    @Override
    public boolean test(R object) {
        GeometryWrapper right;
        GeometryWrapper left = (GeometryWrapper)this.expression1.apply(object);
        if (left != null && (right = (GeometryWrapper)this.expression2.apply(object)) != null) {
            try {
                return left.predicate(this.operatorType, right, this.context);
            }
            catch (RuntimeException e) {
                this.warning(e, true);
            }
        }
        return this.negativeResult();
    }

    @Override
    protected boolean negativeResult() {
        return SpatialOperationContext.negativeResult(this.operatorType);
    }
}

