/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import org.apache.sis.filter.ArithmeticFunction;
import org.apache.sis.filter.BinarySpatialFilter;
import org.apache.sis.filter.Capabilities;
import org.apache.sis.filter.ComparisonFilter;
import org.apache.sis.filter.DefaultSortProperty;
import org.apache.sis.filter.DistanceFilter;
import org.apache.sis.filter.IdentifierFilter;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.LikeFilter;
import org.apache.sis.filter.LogicalFilter;
import org.apache.sis.filter.PropertyValue;
import org.apache.sis.filter.TemporalFilter;
import org.apache.sis.filter.UnaryFunction;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.filter.FunctionRegister;
import org.apache.sis.internal.filter.sqlmm.Registry;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.feature.Feature;
import org.opengis.filter.BetweenComparisonOperator;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinarySpatialOperator;
import org.opengis.filter.DistanceOperator;
import org.opengis.filter.DistanceOperatorName;
import org.opengis.filter.Expression;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.LikeOperator;
import org.opengis.filter.Literal;
import org.opengis.filter.LogicalOperator;
import org.opengis.filter.MatchAction;
import org.opengis.filter.NilOperator;
import org.opengis.filter.NullOperator;
import org.opengis.filter.ResourceId;
import org.opengis.filter.SortOrder;
import org.opengis.filter.SortProperty;
import org.opengis.filter.SpatialOperatorName;
import org.opengis.filter.TemporalOperator;
import org.opengis.filter.ValueReference;
import org.opengis.filter.Version;
import org.opengis.filter.capability.FilterCapabilities;
import org.opengis.geometry.Envelope;

public abstract class DefaultFilterFactory<R, G, T>
extends AbstractFactory
implements FilterFactory<R, G, T> {
    private final Geometries<G> library;
    private final WraparoundMethod wraparound;
    private final Map<String, FunctionRegister> availableFunctions;

    protected DefaultFilterFactory(Class<G> spatial, Class<T> temporal, WraparoundMethod wraparound) {
        ArgumentChecks.ensureNonNull("spatial", spatial);
        ArgumentChecks.ensureNonNull("temporal", temporal);
        ArgumentChecks.ensureNonNull("wraparound", (Object)wraparound);
        if (spatial == Object.class) {
            this.library = Geometries.implementation((GeometryLibrary)null);
        } else {
            this.library = Geometries.implementation(spatial);
            if (this.library == null || this.library.rootClass != spatial) {
                throw new IllegalArgumentException(Errors.format((short)45, "spatial", spatial));
            }
        }
        if (temporal != Object.class) {
            throw new IllegalArgumentException(Errors.format((short)45, "temporal", temporal));
        }
        this.wraparound = wraparound;
        this.availableFunctions = new HashMap<String, FunctionRegister>();
    }

    public static FilterFactory<Feature, Object, Object> forFeatures() {
        return Features.DEFAULT;
    }

    @Override
    public FilterCapabilities getCapabilities() {
        return Capabilities.INSTANCE;
    }

    @Override
    public <V> Literal<R, V> literal(V value) {
        return new LeafExpression.Literal(value);
    }

    @Override
    public BinaryComparisonOperator<R> equal(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
        return new ComparisonFilter.EqualTo<R>(expression1, expression2, isMatchingCase, matchAction);
    }

    @Override
    public BinaryComparisonOperator<R> notEqual(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
        return new ComparisonFilter.NotEqualTo<R>(expression1, expression2, isMatchingCase, matchAction);
    }

    @Override
    public BinaryComparisonOperator<R> less(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
        return new ComparisonFilter.LessThan<R>(expression1, expression2, isMatchingCase, matchAction);
    }

    @Override
    public BinaryComparisonOperator<R> greater(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
        return new ComparisonFilter.GreaterThan<R>(expression1, expression2, isMatchingCase, matchAction);
    }

    @Override
    public BinaryComparisonOperator<R> lessOrEqual(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
        return new ComparisonFilter.LessThanOrEqualTo<R>(expression1, expression2, isMatchingCase, matchAction);
    }

    @Override
    public BinaryComparisonOperator<R> greaterOrEqual(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
        return new ComparisonFilter.GreaterThanOrEqualTo<R>(expression1, expression2, isMatchingCase, matchAction);
    }

    @Override
    public BetweenComparisonOperator<R> between(Expression<R, ?> expression, Expression<R, ?> lowerBoundary, Expression<R, ?> upperBoundary) {
        return new ComparisonFilter.Between<R>(expression, lowerBoundary, upperBoundary);
    }

    @Override
    public LikeOperator<R> like(Expression<R, ?> expression, String pattern, char wildcard, char singleChar, char escape, boolean isMatchingCase) {
        return new LikeFilter<R>(expression, pattern, wildcard, singleChar, escape, isMatchingCase);
    }

    @Override
    public NullOperator<R> isNull(Expression<R, ?> expression) {
        return new UnaryFunction.IsNull<R>(expression);
    }

    @Override
    public NilOperator<R> isNil(Expression<R, ?> expression, String nilReason) {
        return new UnaryFunction.IsNil<R>(expression, nilReason);
    }

    @Override
    public LogicalOperator<R> and(Filter<R> operand1, Filter<R> operand2) {
        ArgumentChecks.ensureNonNull("operand1", operand1);
        ArgumentChecks.ensureNonNull("operand2", operand2);
        return new LogicalFilter.And<R>(operand1, operand2);
    }

    @Override
    public LogicalOperator<R> and(Collection<? extends Filter<R>> operands) {
        return new LogicalFilter.And(operands);
    }

    @Override
    public LogicalOperator<R> or(Filter<R> operand1, Filter<R> operand2) {
        ArgumentChecks.ensureNonNull("operand1", operand1);
        ArgumentChecks.ensureNonNull("operand2", operand2);
        return new LogicalFilter.Or<R>(operand1, operand2);
    }

    @Override
    public LogicalOperator<R> or(Collection<? extends Filter<R>> operands) {
        return new LogicalFilter.Or(operands);
    }

    @Override
    public LogicalOperator<R> not(Filter<R> operand) {
        return new LogicalFilter.Not<R>(operand);
    }

    @Override
    public BinarySpatialOperator<R> bbox(Expression<R, ? extends G> geometry, Envelope bounds) {
        return new BinarySpatialFilter<R, G>(this.library, geometry, bounds, this.wraparound);
    }

    @Override
    public BinarySpatialOperator<R> equals(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.EQUALS, this.library, geometry1, geometry2);
    }

    @Override
    public BinarySpatialOperator<R> disjoint(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.DISJOINT, this.library, geometry1, geometry2);
    }

    @Override
    public BinarySpatialOperator<R> intersects(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.INTERSECTS, this.library, geometry1, geometry2);
    }

    @Override
    public BinarySpatialOperator<R> touches(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.TOUCHES, this.library, geometry1, geometry2);
    }

    @Override
    public BinarySpatialOperator<R> crosses(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.CROSSES, this.library, geometry1, geometry2);
    }

    @Override
    public BinarySpatialOperator<R> within(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.WITHIN, this.library, geometry1, geometry2);
    }

    @Override
    public BinarySpatialOperator<R> contains(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.CONTAINS, this.library, geometry1, geometry2);
    }

    @Override
    public BinarySpatialOperator<R> overlaps(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.OVERLAPS, this.library, geometry1, geometry2);
    }

    @Override
    public DistanceOperator<R> beyond(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2, Quantity<Length> distance) {
        return new DistanceFilter<R, G>(DistanceOperatorName.BEYOND, this.library, geometry1, geometry2, distance);
    }

    @Override
    public DistanceOperator<R> within(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2, Quantity<Length> distance) {
        return new DistanceFilter<R, G>(DistanceOperatorName.WITHIN, this.library, geometry1, geometry2, distance);
    }

    @Override
    public TemporalOperator<R> after(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return new TemporalFilter.After<R>(time1, time2);
    }

    @Override
    public TemporalOperator<R> before(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return new TemporalFilter.Before<R>(time1, time2);
    }

    @Override
    public TemporalOperator<R> begins(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return new TemporalFilter.Begins<R>(time1, time2);
    }

    @Override
    public TemporalOperator<R> begunBy(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return new TemporalFilter.BegunBy<R>(time1, time2);
    }

    @Override
    public TemporalOperator<R> tcontains(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return new TemporalFilter.Contains<R>(time1, time2);
    }

    @Override
    public TemporalOperator<R> during(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return new TemporalFilter.During<R>(time1, time2);
    }

    @Override
    public TemporalOperator<R> tequals(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return new TemporalFilter.Equals<R>(time1, time2);
    }

    @Override
    public TemporalOperator<R> toverlaps(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return new TemporalFilter.Overlaps<R>(time1, time2);
    }

    @Override
    public TemporalOperator<R> meets(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return new TemporalFilter.Meets<R>(time1, time2);
    }

    @Override
    public TemporalOperator<R> ends(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return new TemporalFilter.Ends<R>(time1, time2);
    }

    @Override
    public TemporalOperator<R> overlappedBy(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return new TemporalFilter.OverlappedBy<R>(time1, time2);
    }

    @Override
    public TemporalOperator<R> metBy(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return new TemporalFilter.MetBy<R>(time1, time2);
    }

    @Override
    public TemporalOperator<R> endedBy(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return new TemporalFilter.EndedBy<R>(time1, time2);
    }

    @Override
    public TemporalOperator<R> anyInteracts(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return new TemporalFilter.AnyInteracts<R>(time1, time2);
    }

    @Override
    public Expression<R, Number> add(Expression<R, ? extends Number> operand1, Expression<R, ? extends Number> operand2) {
        return new ArithmeticFunction.Add<R>(operand1, operand2);
    }

    @Override
    public Expression<R, Number> subtract(Expression<R, ? extends Number> operand1, Expression<R, ? extends Number> operand2) {
        return new ArithmeticFunction.Subtract<R>(operand1, operand2);
    }

    @Override
    public Expression<R, Number> multiply(Expression<R, ? extends Number> operand1, Expression<R, ? extends Number> operand2) {
        return new ArithmeticFunction.Multiply<R>(operand1, operand2);
    }

    @Override
    public Expression<R, Number> divide(Expression<R, ? extends Number> operand1, Expression<R, ? extends Number> operand2) {
        return new ArithmeticFunction.Divide<R>(operand1, operand2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression<R, ?> function(String name, Expression<R, ?>[] parameters) {
        FunctionRegister register;
        ArgumentChecks.ensureNonNull("name", name);
        ArgumentChecks.ensureNonNull("parameters", parameters);
        parameters = (Expression[])parameters.clone();
        for (int i = 0; i < parameters.length; ++i) {
            ArgumentChecks.ensureNonNullElement("parameters", i, parameters[i]);
        }
        Map<String, FunctionRegister> map = this.availableFunctions;
        synchronized (map) {
            if (this.availableFunctions.isEmpty()) {
                Registry r = new Registry(this.library);
                for (String fn : r.getNames()) {
                    this.availableFunctions.put(fn, r);
                }
                for (FunctionRegister er : ServiceLoader.load(FunctionRegister.class)) {
                    for (String fn : er.getNames()) {
                        this.availableFunctions.putIfAbsent(fn, er);
                    }
                }
            }
            register = this.availableFunctions.get(name);
        }
        if (register == null) {
            throw new IllegalArgumentException(Resources.format((short)70, name));
        }
        return register.create(name, parameters);
    }

    @Override
    public SortProperty<R> sort(ValueReference<R, ?> property, SortOrder order) {
        return new DefaultSortProperty<R>(property, order);
    }

    public static class Features<G, T>
    extends DefaultFilterFactory<Feature, G, T> {
        static final FilterFactory<Feature, Object, Object> DEFAULT = new Features<Object, Object>(Object.class, Object.class, WraparoundMethod.SPLIT);

        public Features(Class<G> spatial, Class<T> temporal, WraparoundMethod wraparound) {
            super(spatial, temporal, wraparound);
        }

        @Override
        public ResourceId<Feature> resourceId(String identifier) {
            return new IdentifierFilter(identifier);
        }

        @Override
        public ResourceId<Feature> resourceId(String identifier, Version version, Instant startTime, Instant endTime) {
            return new IdentifierFilter(identifier);
        }

        @Override
        public <V> ValueReference<Feature, V> property(String xpath, Class<V> type) {
            ArgumentChecks.ensureNonEmpty("xpath", xpath);
            ArgumentChecks.ensureNonNull("type", type);
            return PropertyValue.create(xpath, type);
        }
    }
}

