/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.List;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.filter.Node;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.feature.Feature;
import org.opengis.filter.Expression;
import org.opengis.filter.Filter;
import org.opengis.filter.ResourceId;

final class IdentifierFilter
extends Node
implements ResourceId<Feature>,
Optimization.OnFilter<Feature> {
    private static final long serialVersionUID = 1404452049863376235L;
    private final String identifier;

    IdentifierFilter(String identifier) {
        ArgumentChecks.ensureNonEmpty("identifier", identifier);
        this.identifier = identifier;
    }

    @Override
    public Filter<Feature> optimize(Optimization optimization) {
        return this;
    }

    @Override
    public Class<Feature> getResourceClass() {
        return Feature.class;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public List<Expression<Feature, ?>> getExpressions() {
        return List.of(new LeafExpression.Literal(this.identifier));
    }

    @Override
    protected Collection<?> getChildren() {
        return List.of(this.identifier);
    }

    @Override
    public boolean test(Feature object) {
        if (object == null) {
            return false;
        }
        Object id = object.getValueOrFallback("sis:identifier", null);
        return id != null && this.identifier.equals(id.toString());
    }
}

