/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import org.apache.sis.geometry.ArrayEnvelope;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ImmutableEnvelope
extends ArrayEnvelope
implements Serializable {
    private static final long serialVersionUID = 8740224085449107870L;

    public ImmutableEnvelope(DirectPosition lowerCorner, DirectPosition upperCorner) throws MismatchedDimensionException, MismatchedReferenceSystemException {
        super(lowerCorner, upperCorner);
    }

    public ImmutableEnvelope(double[] lowerCorner, double[] upperCorner, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(lowerCorner, upperCorner);
        this.crs = crs;
        ArgumentChecks.ensureDimensionMatches("crs", this.getDimension(), crs);
    }

    public ImmutableEnvelope(GeographicBoundingBox box) {
        super(box);
    }

    public ImmutableEnvelope(Envelope envelope) {
        super(envelope);
    }

    public ImmutableEnvelope(CoordinateReferenceSystem crs, Envelope envelope) throws MismatchedDimensionException {
        super(envelope);
        this.crs = crs;
        ArgumentChecks.ensureDimensionMatches("crs", this.getDimension(), crs);
    }

    public ImmutableEnvelope(CoordinateReferenceSystem crs, CharSequence wkt) throws IllegalArgumentException, MismatchedDimensionException {
        super(wkt);
        this.crs = crs;
        ArgumentChecks.ensureDimensionMatches("crs", this.getDimension(), crs);
    }

    public static ImmutableEnvelope castOrCopy(Envelope envelope) {
        if (envelope == null || envelope instanceof ImmutableEnvelope) {
            return (ImmutableEnvelope)envelope;
        }
        return new ImmutableEnvelope(envelope);
    }
}

