/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import org.apache.sis.image.ComputedImage;
import org.apache.sis.internal.coverage.j2d.ObservableImage;

abstract class WritableComputedImage
extends ComputedImage {
    private volatile TileObserver[] observers;

    protected WritableComputedImage(SampleModel sampleModel, RenderedImage ... sources) {
        super(sampleModel, sources);
    }

    public synchronized void addTileObserver(TileObserver observer) {
        this.observers = ObservableImage.addTileObserver(this.observers, observer);
    }

    public synchronized void removeTileObserver(TileObserver observer) {
        this.observers = ObservableImage.removeTileObserver(this.observers, observer);
    }

    @Override
    protected boolean markTileWritable(int tileX, int tileY, boolean writing) {
        boolean notify = super.markTileWritable(tileX, tileY, writing);
        if (notify && this instanceof WritableRenderedImage) {
            ObservableImage.fireTileUpdate(this.observers, (WritableRenderedImage)((Object)this), tileX, tileY, writing);
        }
        return notify;
    }

    public WritableRaster getWritableTile(int tileX, int tileY) {
        WritableRaster tile = (WritableRaster)this.getTile(tileX, tileY);
        this.markTileWritable(tileX, tileY, true);
        return tile;
    }

    public void releaseWritableTile(int tileX, int tileY) {
        if (this.markTileWritable(tileX, tileY, false)) {
            this.setData(this.getTile(tileX, tileY));
        }
    }

    protected void setData(Raster data) {
        throw new UnsupportedOperationException();
    }
}

