/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.sis.index.tree.PointTree;
import org.apache.sis.index.tree.PointTreeNode;
import org.apache.sis.internal.util.Numerics;
import org.opengis.geometry.Envelope;

class NodeIterator<E>
implements Spliterator<E>,
Cloneable {
    private static final Object[] FINISHED = new Object[0];
    private final PointTree.Locator<? super E> locator;
    private final long bitmask;
    private final double[] bounds;
    private double[] point;
    private Cursor<E> cursor;
    private Object[] current;
    private int nextIndex;
    private Cursor<E> recycle;

    NodeIterator(PointTree<E> tree, Envelope searchRegion) {
        int n = tree.getDimension();
        this.bitmask = Numerics.bitmask(1 << n) - 1L;
        this.bounds = new double[n * 2];
        if (searchRegion != null) {
            this.point = new double[n];
            int i = n;
            while (--i >= 0) {
                this.bounds[i] = searchRegion.getMinimum(i);
                this.bounds[i + n] = searchRegion.getMaximum(i);
            }
        } else {
            Arrays.fill(this.bounds, 0, n, Double.NEGATIVE_INFINITY);
            Arrays.fill(this.bounds, n, n * 2, Double.POSITIVE_INFINITY);
        }
        this.locator = tree.locator;
        this.cursor = new Cursor(tree.treeRegion);
        this.cursor.node = tree.root;
        this.cursor.findIntersections(this);
        this.current = this.next();
    }

    private boolean postClone(long quadrants) {
        Cursor<E> c = this.cursor;
        if (this.point != null) {
            this.point = new double[this.point.length];
        }
        this.cursor = new Cursor(c.region);
        this.cursor.parent = c.parent;
        this.cursor.node = c.node;
        this.cursor.quadrants = quadrants;
        this.recycle = null;
        this.nextIndex = 0;
        this.current = this.next();
        return this.current != null;
    }

    private Object[] next() {
        while (this.cursor != null) {
            while (this.cursor.quadrants != 0L) {
                int q = Long.numberOfTrailingZeros(this.cursor.quadrants);
                this.cursor.quadrants &= (long)(~(1 << q));
                Object child = this.cursor.node.getChild(q);
                if (child == null) continue;
                if (child instanceof Object[]) {
                    return (Object[])child;
                }
                if (this.cursor.quadrants != 0L) {
                    this.cursor = this.cursor.push(this, q);
                } else {
                    this.cursor.moveDown(q);
                }
                this.cursor.node = (PointTreeNode)child;
                this.cursor.findIntersections(this);
            }
            this.cursor = this.cursor.getParentAndRecycle(this);
        }
        return FINISHED;
    }

    @Override
    public final boolean tryAdvance(Consumer<? super E> action) {
        Object element;
        while (true) {
            if (this.nextIndex >= this.current.length) {
                if (this.current == FINISHED) {
                    return false;
                }
                this.current = this.next();
                this.nextIndex = 0;
                continue;
            }
            if (this.filter(element = this.current[this.nextIndex++])) break;
        }
        action.accept(element);
        return true;
    }

    protected boolean filter(E element) {
        int n;
        this.locator.getPositionOf(element, this.point);
        int i = n = this.bounds.length >>> 1;
        while (--i >= 0) {
            double p = this.point[i];
            if (p >= this.bounds[i] && p <= this.bounds[i + n]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Spliterator<E> trySplit() {
        Cursor<E> c = this.cursor;
        if (c != null) {
            long half = 0L;
            for (int n = Long.bitCount(c.quadrants) / 2; n >= 0; --n) {
                long q = Long.lowestOneBit(c.quadrants);
                c.quadrants &= q ^ 0xFFFFFFFFFFFFFFFFL;
                half |= q;
            }
            if (half != 0L) {
                try {
                    NodeIterator second = (NodeIterator)this.clone();
                    if (second.postClone(half)) {
                        return second;
                    }
                }
                catch (CloneNotSupportedException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 257;
    }

    private static final class Cursor<E> {
        private Cursor<E> parent;
        PointTreeNode node;
        long quadrants;
        private final double[] region;
        private static final long[] CLEAR_MASKS = new long[]{0x5555555555555555L, 0x3333333333333333L, 0xF0F0F0F0F0F0F0FL, 0xFF00FF00FF00FFL, 0xFFFF0000FFFFL, 0xFFFFFFFFL};

        Cursor(double[] region) {
            this.region = (double[])region.clone();
        }

        final void findIntersections(NodeIterator<E> it) {
            int n;
            double[] bounds = it.bounds;
            this.quadrants = it.bitmask;
            int i = n = bounds.length >>> 1;
            while (--i >= 0) {
                double c = this.region[i];
                if (!(bounds[i] <= c)) {
                    this.quadrants &= CLEAR_MASKS[i];
                }
                if (bounds[i + n] >= c) continue;
                this.quadrants &= CLEAR_MASKS[i] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }

        final Cursor<E> push(NodeIterator<E> it, int q) {
            Cursor c = it.recycle;
            if (c == null) {
                c = new Cursor<E>(this.region);
            } else {
                it.recycle = c.parent;
                System.arraycopy(this.region, 0, c.region, 0, this.region.length);
            }
            PointTreeNode.enterQuadrant(c.region, q);
            c.parent = this;
            return c;
        }

        final void moveDown(int q) {
            PointTreeNode.enterQuadrant(this.region, q);
        }

        final Cursor<E> getParentAndRecycle(NodeIterator<E> it) {
            Cursor<E> p = this.parent;
            this.parent = it.recycle;
            it.recycle = this;
            return p;
        }
    }
}

