/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.color.ColorSpace;
import org.apache.sis.internal.util.Numerics;

final class ScaledColorSpace
extends ColorSpace {
    private static final long serialVersionUID = -5146474397268513490L;
    final double scale;
    final double offset;
    final double maximum;
    final int visibleBand;

    ScaledColorSpace(int numComponents, int visibleBand, double minimum, double maximum) {
        super(6, numComponents);
        this.visibleBand = visibleBand;
        this.maximum = maximum;
        this.scale = 256.0 / (maximum - minimum);
        this.offset = minimum;
    }

    ScaledColorSpace(ScaledColorSpace parent, int numComponents, int visibleBand) {
        super(6, numComponents);
        this.scale = parent.scale;
        this.offset = parent.offset;
        this.maximum = parent.maximum;
        this.visibleBand = visibleBand;
    }

    @Override
    public float[] toRGB(float[] samples) {
        float value = Math.min(1.0f, (float)(((double)samples[this.visibleBand] - this.offset) * (0.00390625 * this.scale)));
        if (!(value >= 0.0f)) {
            value = 0.0f;
        }
        return new float[]{value, value, value};
    }

    @Override
    public float[] fromRGB(float[] color) {
        float[] values = new float[this.getNumComponents()];
        values[this.visibleBand] = (float)((double)(color[0] + color[1] + color[2]) / (0.01171875 * this.scale) + this.offset);
        return values;
    }

    @Override
    public float[] toCIEXYZ(float[] values) {
        float[] codes = this.toRGB(values);
        codes[0] = codes[0] * 0.9642f;
        codes[2] = codes[2] * 0.8249f;
        return codes;
    }

    @Override
    public float[] fromCIEXYZ(float[] color) {
        float[] values = new float[this.getNumComponents()];
        values[this.visibleBand] = (float)((double)(color[0] / 0.9642f + color[1] + color[2] / 0.8249f) / (0.01171875 * this.scale) + this.offset);
        return values;
    }

    @Override
    public float getMinValue(int component) {
        return (float)this.offset;
    }

    @Override
    public float getMaxValue(int component) {
        return (float)this.maximum;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(20).append(this.getClass().getSimpleName());
        this.formatRange(buffer);
        return buffer.toString();
    }

    final void formatRange(StringBuilder buffer) {
        buffer.append('[').append(this.offset).append(" \u2026 ").append(this.maximum).append(" in band ").append(this.visibleBand).append(']');
    }

    public int hashCode() {
        return Long.hashCode(Double.doubleToLongBits(this.scale) + 31L * Double.doubleToLongBits(this.offset)) + 7 * this.getNumComponents() + this.visibleBand;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScaledColorSpace) {
            ScaledColorSpace that = (ScaledColorSpace)obj;
            return Numerics.equals(this.scale, that.scale) && Numerics.equals(this.offset, that.offset) && Numerics.equals(this.maximum, that.maximum) && this.visibleBand == that.visibleBand && this.getNumComponents() == that.getNumComponents() && this.getType() == that.getType();
        }
        return false;
    }
}

