/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.Optional;
import org.apache.sis.feature.Features;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.util.Static;
import org.apache.sis.util.iso.Names;
import org.opengis.feature.Attribute;
import org.opengis.feature.AttributeType;
import org.opengis.feature.FeatureType;
import org.opengis.feature.IdentifiedType;
import org.opengis.feature.Property;
import org.opengis.feature.PropertyNotFoundException;
import org.opengis.feature.PropertyType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;

public final class AttributeConvention
extends Static {
    private static final LocalName SCOPE = Names.createLocalName("Apache", null, "sis");
    public static final ScopedName IDENTIFIER_PROPERTY = Names.createScopedName(SCOPE, null, "identifier");
    public static final ScopedName GEOMETRY_PROPERTY = Names.createScopedName(SCOPE, null, "geometry");
    public static final ScopedName ENVELOPE_PROPERTY = Names.createScopedName(SCOPE, null, "envelope");
    public static final ScopedName CRS_CHARACTERISTIC = Names.createScopedName(SCOPE, null, "crs");
    public static final ScopedName UNIT_CHARACTERISTIC = Names.createScopedName(SCOPE, null, "unit");
    public static final ScopedName MAXIMAL_LENGTH_CHARACTERISTIC = Names.createScopedName(SCOPE, null, "maximalLength");
    public static final GenericName VALID_VALUES_CHARACTERISTIC = Names.createScopedName(SCOPE, null, "validValues");
    public static final String IDENTIFIER = "sis:identifier";
    public static final String GEOMETRY = "sis:geometry";
    public static final String ENVELOPE = "sis:envelope";
    public static final String CRS = "sis:crs";
    public static final String UNIT = "sis:unit";
    public static final String MAXIMAL_LENGTH = "sis:maximalLength";

    private AttributeConvention() {
    }

    public static boolean contains(GenericName name) {
        while (name instanceof ScopedName) {
            if (SCOPE.equals(((ScopedName)name).path())) {
                return true;
            }
            name = ((ScopedName)name).tail();
        }
        return false;
    }

    public static boolean hasIdentifier(FeatureType feature) {
        if (feature != null) {
            try {
                return feature.getProperty(IDENTIFIER) != null;
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isGeometryAttribute(IdentifiedType type) {
        Optional<AttributeType<?>> at = Features.toAttribute(type);
        return at.isPresent() && Geometries.isKnownType(at.get().getValueClass());
    }

    public static boolean characterizedByCRS(IdentifiedType type) {
        return AttributeConvention.hasCharacteristic(type, CRS, CoordinateReferenceSystem.class);
    }

    public static CoordinateReferenceSystem getCRSCharacteristic(Property attribute) {
        return (CoordinateReferenceSystem)AttributeConvention.getCharacteristic(attribute, CRS);
    }

    public static CoordinateReferenceSystem getCRSCharacteristic(FeatureType feature, PropertyType attribute) {
        return (CoordinateReferenceSystem)AttributeConvention.getCharacteristic(feature, attribute, CRS);
    }

    public static boolean characterizedByMaximalLength(IdentifiedType type) {
        return AttributeConvention.hasCharacteristic(type, MAXIMAL_LENGTH, Integer.class);
    }

    public static Integer getMaximalLengthCharacteristic(Property attribute) {
        return (Integer)AttributeConvention.getCharacteristic(attribute, MAXIMAL_LENGTH);
    }

    public static Integer getMaximalLengthCharacteristic(FeatureType feature, PropertyType attribute) {
        return (Integer)AttributeConvention.getCharacteristic(feature, attribute, MAXIMAL_LENGTH);
    }

    private static boolean hasCharacteristic(IdentifiedType type, String name, Class<?> valueClass) {
        AttributeType<?> ct;
        Optional<AttributeType<?>> at = Features.toAttribute(type);
        if (at.isPresent() && (ct = at.get().characteristics().get(name)) != null) {
            return valueClass.isAssignableFrom(ct.getValueClass());
        }
        return false;
    }

    private static Object getCharacteristic(Property attribute, String name) {
        if (attribute instanceof Attribute) {
            Object value;
            Attribute<?> at = ((Attribute)attribute).characteristics().get(name);
            if (at != null && (value = at.getValue()) != null) {
                return value;
            }
            AttributeType<?> type = ((Attribute)attribute).getType().characteristics().get(name);
            if (type != null) {
                return type.getDefaultValue();
            }
        }
        return null;
    }

    private static Object getCharacteristic(FeatureType feature, PropertyType property, String characteristic) {
        AttributeType<?> type;
        Optional<String> referent = Features.getLinkTarget(property);
        if (referent.isPresent() && feature != null) {
            property = feature.getProperty(referent.get());
        }
        if (property instanceof AttributeType && (type = ((AttributeType)property).characteristics().get(characteristic)) != null) {
            return type.getDefaultValue();
        }
        return null;
    }
}

