/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter;

import java.util.Collection;
import java.util.List;
import org.apache.sis.filter.Optimization;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.filter.Node;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.opengis.filter.Expression;
import org.opengis.filter.InvalidFilterValueException;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.util.ScopedName;

final class GeometryConverter<R, G>
extends Node
implements Optimization.OnExpression<R, GeometryWrapper<G>> {
    private static final long serialVersionUID = 1164523020740782044L;
    private static final ScopedName NAME = GeometryConverter.createName("GeometryConverter");
    final Geometries<G> library;
    final Expression<R, ?> expression;

    public GeometryConverter(Geometries<G> library, Expression<R, ?> expression) {
        ArgumentChecks.ensureNonNull("expression", expression);
        ArgumentChecks.ensureNonNull("library", library);
        this.expression = expression;
        this.library = library;
    }

    @Override
    public Expression<R, GeometryWrapper<G>> recreate(Expression<R, ?>[] effective) {
        return new GeometryConverter<R, G>(this.library, effective[0]);
    }

    @Override
    public ScopedName getFunctionName() {
        return NAME;
    }

    @Override
    public Class<? super R> getResourceClass() {
        return this.expression.getResourceClass();
    }

    @Override
    public List<Expression<R, ?>> getParameters() {
        return List.of(this.expression);
    }

    @Override
    protected Collection<?> getChildren() {
        return this.getParameters();
    }

    @Override
    public GeometryWrapper<G> apply(R input) {
        Envelope envelope;
        Object value = this.expression.apply(input);
        if (value instanceof GeographicBoundingBox) {
            envelope = new ImmutableEnvelope((GeographicBoundingBox)value);
        } else if (value instanceof Envelope) {
            envelope = (Envelope)value;
        } else {
            try {
                if (value instanceof DirectPosition) {
                    return this.library.createPoint((DirectPosition)value);
                }
                return this.library.castOrWrap(value);
            }
            catch (ClassCastException | MismatchedDimensionException e) {
                throw new InvalidFilterValueException(Errors.format((short)50, this.library.rootClass, Classes.getClass(value)), e);
            }
        }
        return this.library.toGeometry2D(envelope, WraparoundMethod.NONE);
    }

    @Override
    public <N> Expression<R, N> toValueType(Class<N> target) {
        if (target.isAssignableFrom(this.library.rootClass)) {
            return this.expression;
        }
        if (target.isAssignableFrom(GeometryWrapper.class)) {
            return this;
        }
        throw new ClassCastException(Errors.format((short)163, target));
    }
}

