/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter.sqlmm;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.filter.sqlmm.FunctionWithSRID;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.resources.Errors;
import org.opengis.filter.Expression;
import org.opengis.filter.InvalidFilterValueException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class ST_Point<R, G>
extends FunctionWithSRID<R> {
    private static final long serialVersionUID = -6280773709322350835L;
    private final Expression<R, ?>[] parameters;
    private final Geometries<G> library;

    ST_Point(Expression<R, ?>[] parameters, Geometries<G> library) {
        super(SQLMM.ST_Point, parameters, 2);
        this.parameters = parameters;
        this.library = library;
    }

    @Override
    public Expression<R, Object> recreate(Expression<R, ?>[] effective) {
        return new ST_Point(effective, this.getGeometryLibrary());
    }

    @Override
    final Geometries<?> getGeometryLibrary() {
        return this.library;
    }

    @Override
    public Class<? super R> getResourceClass() {
        Class type = super.getResourceClass();
        for (Expression<R, ?> p : this.parameters) {
            type = ST_Point.specializedClass(type, p.getResourceClass());
        }
        return type;
    }

    @Override
    public List<Expression<R, ?>> getParameters() {
        return UnmodifiableArrayList.wrap(this.parameters);
    }

    private double value(R input, int index, String name) {
        Object value = this.parameters[index].apply(input);
        if (value == null) {
            return Double.NaN;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new InvalidFilterValueException(Errors.format((short)43, name, Number.class, value.getClass()));
    }

    private GeometryWrapper<G> parse(Object value) throws Exception {
        GeometryWrapper<G> point;
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            point = this.library.parseWKB(ByteBuffer.wrap((byte[])value));
        } else if (value instanceof ByteBuffer) {
            point = this.library.parseWKB((ByteBuffer)value);
        } else if (value instanceof String) {
            point = this.library.parseWKT((String)value);
        } else {
            throw new InvalidFilterValueException(Errors.format((short)43, "wkt|wkb", String.class, value.getClass()));
        }
        Object implementation = point.implementation();
        if (this.library.pointClass.isInstance(implementation)) {
            return point;
        }
        String type = value instanceof String ? "wkt" : "wkb";
        throw new InvalidFilterValueException(Errors.format((short)43, type, this.library.pointClass, point.getClass()));
    }

    @Override
    public Object apply(R input) {
        CoordinateReferenceSystem crs;
        GeometryWrapper<G> point;
        try {
            switch (this.parameters.length) {
                case 1: {
                    GeometryWrapper<G> point2 = this.parse(this.parameters[0].apply(input));
                    return point2 != null ? point2.implementation() : null;
                }
                case 2: {
                    Object value = this.parameters[0].apply(input);
                    if (value instanceof Number) {
                        double x = ((Number)value).doubleValue();
                        double y = this.value(input, 1, "y");
                        if (Double.isNaN(x) && Double.isNaN(y)) {
                            return null;
                        }
                        return this.library.createPoint(x, y);
                    }
                    point = this.parse(value);
                    if (point == null) {
                        return null;
                    }
                    crs = this.getTargetCRS(input);
                    break;
                }
                case 3: {
                    double x = this.value(input, 0, "x");
                    double y = this.value(input, 1, "y");
                    if (this.literalCRS) {
                        if (Double.isNaN(x) && Double.isNaN(y)) {
                            return null;
                        }
                        point = this.library.castOrWrap(this.library.createPoint(x, y));
                        crs = this.getTargetCRS(input);
                        break;
                    }
                    double z = this.value(input, 2, "z");
                    if (Double.isNaN(x) && Double.isNaN(y) && Double.isNaN(z)) {
                        return null;
                    }
                    return this.library.createPoint(x, y, z);
                }
                case 4: {
                    double x = this.value(input, 0, "x");
                    double y = this.value(input, 1, "y");
                    double z = this.value(input, 2, "z");
                    if (Double.isNaN(x) && Double.isNaN(y) && Double.isNaN(z)) {
                        return null;
                    }
                    point = this.library.castOrWrap(this.library.createPoint(x, y, z));
                    crs = this.getTargetCRS(input);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception e) {
            this.warning(e, false);
            return null;
        }
        if (crs != null) {
            point.setCoordinateReferenceSystem(crs);
        }
        return point.implementation();
    }
}

