/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gml;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.util.iso.Types;
import org.opengis.util.CodeList;

public abstract class CodeListAdapter<BoundType extends CodeList<BoundType>>
extends XmlAdapter<Value, BoundType> {
    protected CodeListAdapter() {
    }

    protected abstract Class<BoundType> getCodeListClass();

    protected String getCodeSpace() {
        return null;
    }

    @Override
    public final BoundType unmarshal(Value identifier) {
        return identifier != null ? (BoundType)Types.forCodeName(this.getCodeListClass(), identifier.value, true) : null;
    }

    @Override
    public final Value marshal(BoundType code) {
        return code != null ? new Value(this.getCodeSpace(), (CodeList<?>)code) : null;
    }

    static final class Value {
        @XmlAttribute
        String codeSpace;
        @XmlValue
        String value;

        Value() {
        }

        Value(String codeSpace, CodeList<?> code) {
            this.codeSpace = codeSpace;
            this.value = Types.getCodeName(code);
        }
    }
}

