/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.lan;

import java.nio.charset.Charset;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.jaxb.lan.PT_Locale;

public final class OtherLocales
extends AbstractSet<PT_Locale> {
    private final Set<PT_Locale> locales;

    private OtherLocales(Set<PT_Locale> locales) {
        this.locales = locales;
    }

    public static Set<PT_Locale> filter(Map<Locale, Charset> locales) {
        Set<PT_Locale> s2 = PT_Locale.wrap(locales);
        return s2 != null ? new OtherLocales(s2) : null;
    }

    @Override
    public int size() {
        int size = this.locales.size();
        if (size > 0) {
            --size;
        }
        return size;
    }

    @Override
    public Iterator<PT_Locale> iterator() {
        Iterator<PT_Locale> it = this.locales.iterator();
        if (it.hasNext()) {
            it.next();
        }
        return it;
    }

    @Override
    public boolean add(PT_Locale locale) {
        if (this.locales.isEmpty()) {
            Locale defaultLocale = Locale.getDefault();
            if (defaultLocale.equals(locale.getLocale())) {
                defaultLocale = Locale.ROOT;
            }
            this.locales.add(new PT_Locale(defaultLocale));
        }
        return this.locales.add(locale);
    }

    public static Map<Locale, Charset> setFirst(Map<Locale, Charset> addTo, PT_Locale newValue) {
        if (newValue != null) {
            Object[] keys = null;
            Object[] values = null;
            if (addTo == null) {
                addTo = new LinkedHashMap<Locale, Charset>();
            } else if (!addTo.isEmpty()) {
                keys = addTo.keySet().toArray();
                values = addTo.values().toArray();
                addTo.clear();
                if (newValue.getCharacterSet() == null) {
                    newValue.setCharacterSet((Charset)values[0]);
                }
            }
            newValue.addInto(addTo);
            if (keys != null) {
                for (int i = 1; i < keys.length; ++i) {
                    addTo.put((Locale)keys[i], (Charset)values[i]);
                }
            }
        }
        return addTo;
    }
}

