/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.metadata.replace;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.metadata.replace.RS_Identifier;
import org.apache.sis.internal.simple.SimpleIdentifiedObject;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.ReferenceSystem;

@XmlType(name="MD_ReferenceSystem_Type", namespace="http://standards.iso.org/iso/19115/-3/mrs/1.0")
@XmlRootElement(name="MD_ReferenceSystem", namespace="http://standards.iso.org/iso/19115/-3/mrs/1.0")
public class ReferenceSystemMetadata
extends SimpleIdentifiedObject
implements ReferenceSystem {
    private static final long serialVersionUID = 2810145397032096087L;
    private boolean isLegacyMetadata;

    public ReferenceSystemMetadata() {
    }

    public ReferenceSystemMetadata(ReferenceSystem crs) {
        super(crs);
    }

    public ReferenceSystemMetadata(Identifier name) {
        super(name);
    }

    private void beforeMarshal(Marshaller marshaller) {
        this.isLegacyMetadata = !FilterByVersion.CURRENT_METADATA.accept();
    }

    @Override
    @XmlElement(name="referenceSystemIdentifier")
    public final Identifier getName() {
        Identifier name = super.getName();
        if (this.isLegacyMetadata) {
            name = RS_Identifier.wrap(name);
        }
        return name;
    }

    public final void setName(Identifier name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode) && object instanceof ReferenceSystem) {
            ReferenceSystem that = (ReferenceSystem)object;
            if (mode.isIgnoringMetadata()) {
                return Utilities.deepEquals(this.getName(), that.getName(), mode);
            }
            return that.getDomainOfValidity() == null && that.getScope() == null;
        }
        return false;
    }
}

