/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.util.FactoryException;

public final class DefinitionVerifier {
    private static final AxesConvention[] VARIANTS = new AxesConvention[]{AxesConvention.NORMALIZED, AxesConvention.DISPLAY_ORIENTED, AxesConvention.RIGHT_HANDED};
    public final CoordinateReferenceSystem recommendation;
    private short resourceKey;
    private Object[] arguments;
    private final Locale locale;
    private static final int METHOD = 0;
    private static final int CONVERSION = 1;
    private static final int CS = 2;
    private static final int DATUM = 3;
    private static final int PRIME_MERIDIAN = 4;
    private static final int OTHER = 5;

    private DefinitionVerifier(CoordinateReferenceSystem recommendation, Locale locale) {
        this.recommendation = recommendation;
        this.locale = locale;
    }

    public static void withAuthority(CoordinateReferenceSystem crs, String logger, Class<?> classe, String method) throws FactoryException {
        LogRecord record;
        DefinitionVerifier verification = DefinitionVerifier.withAuthority(crs, null, false, null);
        if (verification != null && (record = verification.warning(true)) != null) {
            record.setLoggerName(logger);
            Logging.completeAndLog(null, classe, method, record);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefinitionVerifier withAuthority(CoordinateReferenceSystem crs, CRSAuthorityFactory factory, boolean lookup, Locale locale) throws FactoryException {
        CoordinateReferenceSystem authoritative;
        Citation authority = factory != null ? factory.getAuthority() : null;
        String identifier = IdentifiedObjects.toString(IdentifiedObjects.getIdentifier(crs, authority));
        if (identifier != null) {
            try {
                if (factory != null) {
                    authoritative = factory.createCoordinateReferenceSystem(identifier);
                    return DefinitionVerifier.compare(crs, authoritative, identifier != null, identifier == null, locale);
                }
                authoritative = CRS.forCode(identifier);
                return DefinitionVerifier.compare(crs, authoritative, identifier != null, identifier == null, locale);
            }
            catch (NoSuchAuthorityCodeException e) {
                DefinitionVerifier verifier = new DefinitionVerifier(crs, locale);
                verifier.arguments = new String[]{e.getLocalizedMessage()};
                return verifier;
            }
        } else {
            if (!lookup) return null;
            IdentifiedObjectFinder finder = factory instanceof GeodeticAuthorityFactory ? ((GeodeticAuthorityFactory)((Object)factory)).newIdentifiedObjectFinder() : IdentifiedObjects.newFinder(Citations.getIdentifier(authority));
            finder.setIgnoringAxes(true);
            IdentifiedObject ref = finder.findSingleton(crs);
            if (!(ref instanceof CoordinateReferenceSystem)) return null;
            authoritative = (CoordinateReferenceSystem)ref;
        }
        return DefinitionVerifier.compare(crs, authoritative, identifier != null, identifier == null, locale);
    }

    public static DefinitionVerifier compare(CoordinateReferenceSystem crs, CoordinateReferenceSystem authoritative, Locale locale) {
        if (crs == null || authoritative == null) {
            return new DefinitionVerifier(crs != null ? crs : authoritative, locale);
        }
        return DefinitionVerifier.compare(crs, authoritative, false, false, locale);
    }

    private static DefinitionVerifier compare(CoordinateReferenceSystem crs, CoordinateReferenceSystem authoritative, boolean strictAxisOrder, boolean nullIfNoMatch, Locale locale) {
        DefinitionVerifier verifier;
        AbstractCRS ca;
        int similarity = 0;
        AbstractCRS variant = ca = AbstractCRS.castOrCopy(authoritative);
        while (!variant.equals(crs, ComparisonMode.APPROXIMATE)) {
            if (similarity < VARIANTS.length) {
                variant = ca.forConvention(VARIANTS[similarity++]);
                continue;
            }
            if (nullIfNoMatch) {
                return null;
            }
            similarity = -1;
            break;
        }
        if (similarity > 0) {
            verifier = new DefinitionVerifier(variant, locale);
            if (strictAxisOrder) {
                verifier.resourceKey = (short)72;
                verifier.arguments = new String[2];
            }
        } else {
            verifier = new DefinitionVerifier(authoritative, locale);
            if (similarity != 0) {
                verifier.resourceKey = (short)73;
                verifier.arguments = new Object[3];
                verifier.arguments[2] = DefinitionVerifier.diffCode(CRS.getSingleComponents(authoritative).iterator(), CRS.getSingleComponents(crs).iterator());
            }
        }
        if (verifier.arguments != null) {
            verifier.arguments[0] = IdentifiedObjects.getDisplayName(crs, locale);
            verifier.arguments[1] = IdentifiedObjects.getIdentifierOrName(authoritative);
        }
        return verifier;
    }

    private static int diffCode(Iterator<SingleCRS> authoritative, Iterator<SingleCRS> given) {
        while (authoritative.hasNext() && given.hasNext()) {
            Datum datumG;
            Conversion cnvG;
            Conversion cnvA;
            SingleCRS crsG;
            SingleCRS crsA = authoritative.next();
            if (Utilities.equalsApproximately(crsA, crsG = given.next())) continue;
            if (crsA instanceof GeneralDerivedCRS && crsG instanceof GeneralDerivedCRS && !Utilities.equalsApproximately(cnvA = ((GeneralDerivedCRS)crsA).getConversionFromBase(), cnvG = ((GeneralDerivedCRS)crsG).getConversionFromBase())) {
                return Utilities.equalsApproximately(cnvA.getMethod(), cnvG.getMethod()) ? 1 : 0;
            }
            if (!Utilities.equalsApproximately(crsA.getCoordinateSystem(), crsG.getCoordinateSystem())) {
                return 2;
            }
            Datum datumA = crsA.getDatum();
            if (Utilities.equalsApproximately(datumA, datumG = crsG.getDatum())) break;
            if (datumA instanceof GeodeticDatum && datumG instanceof GeodeticDatum && !Utilities.equalsApproximately(((GeodeticDatum)datumA).getPrimeMeridian(), ((GeodeticDatum)datumG).getPrimeMeridian())) {
                return 4;
            }
            return 3;
        }
        return 5;
    }

    public LogRecord warning(boolean fine) {
        if (this.arguments != null) {
            if (this.resourceKey != 0) {
                return Resources.forLocale(this.locale).getLogRecord(Level.WARNING, this.resourceKey, this.arguments);
            }
            if (fine) {
                return new LogRecord(Level.FINE, (String)this.arguments[0]);
            }
        }
        return null;
    }
}

