/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.Matrix;

public interface ExtendedPrecisionMatrix
extends Matrix {
    public static final Number[] CREATE_ZERO = new Number[0];
    public static final Number[] CREATE_IDENTITY = new Number[0];

    public static boolean isZero(Number element) {
        return element == null || element.doubleValue() == 0.0;
    }

    default public Number[] getElementAsNumbers(boolean writable) {
        int numCol = this.getNumCol();
        Number[] elements = new Number[this.getNumRow() * numCol];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = this.getElementOrNull(i / numCol, i % numCol);
        }
        return elements;
    }

    public Number getElementOrNull(int var1, int var2);

    @Override
    default public double getElement(int row, int column) {
        Number value = this.getElementOrNull(row, column);
        return value != null ? value.doubleValue() : 0.0;
    }

    @Override
    default public void setElement(int row, int column, double value) {
        throw new UnsupportedOperationException(Errors.format((short)153, this.getClass()));
    }
}

