/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

public class MathTransformsOrFactory {
    private static final MathTransformsOrFactory INSTANCE = new MathTransformsOrFactory();

    private MathTransformsOrFactory() {
    }

    public static MathTransformsOrFactory wrap(MathTransformFactory factory) {
        return factory != null ? new Specified(factory) : INSTANCE;
    }

    public MathTransform linear(Matrix matrix) throws FactoryException {
        return MathTransforms.linear(matrix);
    }

    public MathTransform passThrough(int firstAffectedCoordinate, MathTransform subTransform, int numTrailingCoordinates) throws FactoryException {
        return MathTransforms.passThrough(firstAffectedCoordinate, subTransform, numTrailingCoordinates);
    }

    public MathTransform concatenate(MathTransform tr1, MathTransform tr2) throws FactoryException {
        return MathTransforms.concatenate(tr1, tr2);
    }

    public final MathTransform concatenate(boolean applyOtherFirst, MathTransform tr, MathTransform other) throws FactoryException {
        if (applyOtherFirst) {
            return this.concatenate(other, tr);
        }
        return this.concatenate(tr, other);
    }

    private static final class Specified
    extends MathTransformsOrFactory {
        private final MathTransformFactory factory;

        Specified(MathTransformFactory factory) {
            this.factory = factory;
        }

        @Override
        public MathTransform linear(Matrix matrix) throws FactoryException {
            return this.factory.createAffineTransform(matrix);
        }

        @Override
        public MathTransform passThrough(int firstAffectedCoordinate, MathTransform subTransform, int numTrailingCoordinates) throws FactoryException {
            return this.factory.createPassThroughTransform(firstAffectedCoordinate, subTransform, numTrailingCoordinates);
        }

        @Override
        public MathTransform concatenate(MathTransform tr, MathTransform other) throws FactoryException {
            return this.factory.createConcatenatedTransform(tr, other);
        }
    }
}

