/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.j2d;

import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;

class AffineMatrix
extends MatrixSIS
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8659316010184028768L;
    private static final int SIZE = 3;
    private final AffineTransform transform;

    AffineMatrix(AffineTransform transform) {
        this.transform = transform;
    }

    @Override
    public final int getNumRow() {
        return 3;
    }

    @Override
    public final int getNumCol() {
        return 3;
    }

    @Override
    public final boolean isIdentity() {
        return this.transform.isIdentity();
    }

    @Override
    public final double getElement(int row, int column) {
        ArgumentChecks.ensureBetween("row", 0, 2, row);
        ArgumentChecks.ensureBetween("column", 0, 2, column);
        switch (row * 3 + column) {
            case 0: {
                return this.transform.getScaleX();
            }
            case 1: {
                return this.transform.getShearX();
            }
            case 2: {
                return this.transform.getTranslateX();
            }
            case 3: {
                return this.transform.getShearY();
            }
            case 4: {
                return this.transform.getScaleY();
            }
            case 5: {
                return this.transform.getTranslateY();
            }
            case 8: {
                return 1.0;
            }
        }
        return 0.0;
    }

    @Override
    public final void setElement(int row, int column, double value) {
        throw new UnsupportedOperationException(Resources.format((short)68));
    }

    @Override
    public final void transpose() {
        throw new UnsupportedOperationException(Resources.format((short)68));
    }

    @Override
    public int hashCode() {
        return this.transform.hashCode() ^ 0x40DF3260;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            return this.transform.equals(((AffineMatrix)obj).transform);
        }
        return false;
    }

    @Override
    public final MatrixSIS clone() {
        return Matrices.copy(this);
    }

    @Override
    public final String toString() {
        return Matrices.toString(this);
    }

    static final class ExtendedPrecision
    extends AffineMatrix
    implements ExtendedPrecisionMatrix {
        private static final long serialVersionUID = -4887280720125030417L;
        private static final int LENGTH_STORED = 6;
        private final Number[] elements;

        ExtendedPrecision(AffineTransform transform, Number[] elements) {
            super(transform);
            this.elements = Arrays.copyOf(elements, 6);
        }

        @Override
        public Number[] getElementAsNumbers(boolean writable) {
            Number[] numbers = Arrays.copyOf(this.elements, 9);
            numbers[8] = 1;
            return numbers;
        }

        @Override
        public Number getElementOrNull(int row, int column) {
            ArgumentChecks.ensureBetween("row", 0, 2, row);
            ArgumentChecks.ensureBetween("column", 0, 2, column);
            if (row != 2) {
                return this.elements[row * 3 + column];
            }
            return column == 2 ? Integer.valueOf(1) : null;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + Arrays.hashCode(this.elements);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Arrays.equals(this.elements, ((ExtendedPrecision)obj).elements);
        }
    }
}

