/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.j2d;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.referencing.j2d.ImmutableAffineTransform;
import org.apache.sis.internal.referencing.j2d.Tile;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;

public class TileOrganizer {
    private static final double EPS = 1.0E-10;
    private final int xLocation;
    private final int yLocation;
    private final Map<AffineTransform, Tile> tiles;
    private static final Comparator<AffineTransform> X_COMPARATOR = new Comparator<AffineTransform>(){

        @Override
        public int compare(AffineTransform tr1, AffineTransform tr2) {
            return Double.compare(AffineTransforms2D.getScaleX0(tr1), AffineTransforms2D.getScaleX0(tr2));
        }
    };
    private static final Comparator<AffineTransform> Y_COMPARATOR = new Comparator<AffineTransform>(){

        @Override
        public int compare(AffineTransform tr1, AffineTransform tr2) {
            return Double.compare(AffineTransforms2D.getScaleY0(tr1), AffineTransforms2D.getScaleY0(tr2));
        }
    };

    public TileOrganizer(Point location) {
        if (location != null) {
            this.xLocation = location.x;
            this.yLocation = location.y;
        } else {
            this.yLocation = 0;
            this.xLocation = 0;
        }
        this.tiles = new IdentityHashMap<AffineTransform, Tile>();
    }

    public Point getLocation() {
        return new Point(this.xLocation, this.yLocation);
    }

    public boolean add(Tile tile) {
        AffineTransform gridToCRS = tile.getPendingGridToCRS();
        if (gridToCRS == null) {
            return false;
        }
        if (this.tiles.putIfAbsent(gridToCRS, tile) != null) {
            throw new IllegalStateException();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Tile, Tile[]> tiles() throws IOException {
        HashMap<Tile, Tile[]> results = new HashMap<Tile, Tile[]>(4);
        for (Map<AffineTransform, Dimension> tilesAT : TileOrganizer.computePyramidLevels(this.tiles.keySet())) {
            AffineTransform toGrid;
            AffineTransform reference = null;
            double xMin = Double.POSITIVE_INFINITY;
            double xLead = Double.POSITIVE_INFINITY;
            double yMin = Double.POSITIVE_INFINITY;
            double scale = Double.POSITIVE_INFINITY;
            for (AffineTransform tr : tilesAT.keySet()) {
                double s2 = AffineTransforms2D.getScale(tr);
                double y = tr.getTranslateY();
                if (tr.getScaleY() < 0.0 || tr.getShearY() < 0.0) {
                    y = -y;
                }
                double x = tr.getTranslateX();
                if (tr.getScaleX() < 0.0 || tr.getShearX() < 0.0) {
                    x = -x;
                }
                if (!(Math.abs(s2 - scale) <= 1.0E-10)) {
                    if (!(s2 < scale)) continue;
                    scale = s2;
                    yMin = y;
                    xMin = x;
                } else {
                    if (x < xMin) {
                        xMin = x;
                    }
                    if (!(Math.abs(y - yMin) <= 1.0E-10)) {
                        if (!(y < yMin)) continue;
                        yMin = y;
                    } else if (!(x < xLead)) continue;
                }
                xLead = x;
                reference = tr;
            }
            if (reference == null) continue;
            if ((xLead -= xMin) > 1.0E-10) {
                double[] matrix = new double[6];
                reference.getMatrix(matrix);
                matrix[4] = xMin;
                reference = new AffineTransform(matrix);
            } else {
                reference = new AffineTransform(reference);
            }
            try {
                toGrid = reference.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new IllegalStateException(e);
            }
            int index = 0;
            Rectangle groupBounds = null;
            Rectangle2D.Double envelope = new Rectangle2D.Double();
            Tile[] tilesArray = new Tile[tilesAT.size()];
            for (Map.Entry<AffineTransform, Dimension> entry : tilesAT.entrySet()) {
                Rectangle bounds;
                AffineTransform tr = entry.getKey();
                Tile tile = this.tiles.remove(tr);
                tr.preConcatenate(toGrid);
                Tile tile2 = tile;
                synchronized (tile2) {
                    tile.setSubsampling(entry.getValue());
                    try {
                        bounds = tile.getRegion();
                    }
                    catch (IOException exception) {
                        if (!this.unavailableSize(tile, exception)) {
                            throw exception;
                        }
                        bounds = null;
                    }
                    if (bounds != null) {
                        AffineTransforms2D.transform(tr, bounds, envelope);
                        bounds.x = Math.toIntExact(Math.round(envelope.x));
                        bounds.y = Math.toIntExact(Math.round(envelope.y));
                        bounds.width = Math.toIntExact(Math.round(envelope.width));
                        bounds.height = Math.toIntExact(Math.round(envelope.height));
                    } else {
                        Point location = tile.getLocation();
                        tr.transform(location, location);
                        bounds = new Rectangle(location.x, location.y, 0, 0);
                    }
                    tile.setRegionOnFinestLevel(bounds);
                }
                if (groupBounds == null) {
                    groupBounds = bounds;
                } else {
                    groupBounds.add(bounds);
                }
                tilesArray[index++] = tile;
            }
            tilesAT.clear();
            if (groupBounds == null) continue;
            int dx = this.xLocation - groupBounds.x;
            int dy = this.yLocation - groupBounds.y;
            if ((dx | dy) != 0) {
                reference.translate(-dx, -dy);
                groupBounds.translate(dx, dy);
            }
            reference = new AffineTransform2D(reference);
            HashMap<Dimension, Translation> pool = new HashMap<Dimension, Translation>();
            for (Tile tile : tilesArray) {
                Dimension subsampling = tile.getSubsampling();
                Translation translated = (Translation)pool.get(subsampling);
                if (translated == null) {
                    translated = new Translation(subsampling, reference, dx, dy);
                    pool.put(subsampling, translated);
                }
                translated.applyTo(tile);
            }
            results.put(new Tile(reference, groupBounds), tilesArray);
        }
        return results;
    }

    private static List<Map<AffineTransform, Dimension>> computePyramidLevels(Collection<AffineTransform> gridToCRS) {
        ArrayList<Map<AffineTransform, Dimension>> results = new ArrayList<Map<AffineTransform, Dimension>>(2);
        AffineTransform[] transforms = (AffineTransform[])gridToCRS.toArray(AffineTransform[]::new);
        Arrays.sort(transforms, X_COMPARATOR);
        int length = transforms.length;
        while (length != 0) {
            IdentityHashMap<AffineTransform, Dimension> result = new IdentityHashMap<AffineTransform, Dimension>();
            if (length <= (length = TileOrganizer.computePyramidLevels(transforms, length, result, false))) {
                throw new AssertionError(length);
            }
            results.add(result);
        }
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            Map result = (Map)iterator.next();
            length = result.size();
            transforms = result.keySet().toArray(transforms);
            Arrays.sort(transforms, 0, length, Y_COMPARATOR);
            length = TileOrganizer.computePyramidLevels(transforms, length, result, true);
            while (--length >= 0) {
                if (result.remove(transforms[length]) == null) {
                    throw new AssertionError(length);
                }
            }
            if (!result.isEmpty()) continue;
            iterator.remove();
        }
        return results;
    }

    private static int computePyramidLevels(AffineTransform[] gridToCRS, int length, Map<AffineTransform, Dimension> result, boolean isY) {
        boolean shearIsNull;
        boolean scaleIsNull;
        double shear;
        double scale;
        AffineTransform base;
        int processing = 0;
        int remaining = 0;
        while (true) {
            if (processing >= length) {
                return remaining;
            }
            base = gridToCRS[processing++];
            if (isY) {
                scale = base.getScaleY();
                shear = base.getShearY();
            } else {
                scale = base.getScaleX();
                shear = base.getShearX();
            }
            scaleIsNull = Math.abs(scale) < 1.0E-10;
            boolean bl = shearIsNull = Math.abs(shear) < 1.0E-10;
            if (!(scaleIsNull & shearIsNull)) break;
            result.remove(base);
        }
        if (isY) {
            result.get((Object)base).height = 1;
        } else {
            assert (result.isEmpty()) : result;
            result.put(base, new Dimension(1, 0));
        }
        while (processing < length) {
            int level;
            double shear2;
            double scale2;
            AffineTransform candidate = gridToCRS[processing++];
            if (isY) {
                scale2 = candidate.getScaleY();
                shear2 = candidate.getShearY();
            } else {
                scale2 = candidate.getScaleX();
                shear2 = candidate.getShearX();
            }
            if (scaleIsNull) {
                if (!(Math.abs(scale2) < 1.0E-10)) {
                    gridToCRS[remaining++] = candidate;
                    continue;
                }
                level = TileOrganizer.level(shear2 / shear);
            } else {
                level = TileOrganizer.level(scale2 / scale);
                if (shearIsNull ? !(Math.abs(shear2) < 1.0E-10) : TileOrganizer.level(shear2 / shear) != level) {
                    gridToCRS[remaining++] = candidate;
                    continue;
                }
            }
            if (level == 0) {
                gridToCRS[remaining++] = candidate;
                continue;
            }
            if (isY) {
                result.get((Object)candidate).height = level;
                continue;
            }
            if (result.put(candidate, new Dimension(level, 0)) != null) {
                throw new AssertionError(candidate);
            }
        }
        Arrays.fill(gridToCRS, remaining, length, null);
        return remaining;
    }

    private static int level(double ratio) {
        if (ratio > 0.0 && ratio < Double.POSITIVE_INFINITY) {
            double integer;
            boolean inverse;
            boolean bl = inverse = ratio < 0.75;
            if (inverse) {
                ratio = 1.0 / ratio;
            }
            if ((integer = Math.rint(ratio)) < 2.147483647E9 && Math.abs(ratio - integer) < 1.0E-10) {
                int level = (int)integer;
                if (inverse) {
                    level = -level;
                }
                return level;
            }
        }
        return 0;
    }

    protected boolean unavailableSize(Tile tile, IOException exception) {
        return false;
    }

    public String toString() {
        return Tile.toString(this.tiles.values(), 400);
    }

    private static final class Translation {
        private final AffineTransform gridToCRS;
        private final int dx;
        private final int dy;

        Translation(Dimension subsampling, AffineTransform reference, int dx, int dy) {
            this.dx = dx / subsampling.width;
            this.dy = dy / subsampling.height;
            reference = new AffineTransform(reference);
            reference.scale(subsampling.width, subsampling.height);
            reference.translate(dx %= subsampling.width, dy %= subsampling.height);
            this.gridToCRS = new ImmutableAffineTransform(reference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void applyTo(Tile tile) {
            Tile tile2 = tile;
            synchronized (tile2) {
                tile.translate(this.dx, this.dy);
                tile.setGridToCRS(this.gridToCRS);
            }
        }
    }
}

