/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.GenericName;

@XmlTransient
public abstract class AbstractProvider
extends DefaultOperationMethod
implements MathTransformProvider {
    private static final long serialVersionUID = 1165868434518724597L;
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.referencing.operation");
    private final Class<? extends SingleOperation> operationType;
    public final Class<? extends CoordinateSystem> sourceCSType;
    public final Class<? extends CoordinateSystem> targetCSType;
    public final boolean sourceOnEllipsoid;
    public final boolean targetOnEllipsoid;

    protected AbstractProvider(Map<String, ?> properties, int sourceDimension, int targetDimension, ParameterDescriptorGroup parameters) {
        super(properties, sourceDimension, targetDimension, parameters);
        this.operationType = SingleOperation.class;
        this.sourceCSType = CoordinateSystem.class;
        this.targetCSType = CoordinateSystem.class;
        this.sourceOnEllipsoid = false;
        this.targetOnEllipsoid = false;
    }

    AbstractProvider(Class<? extends SingleOperation> operationType, ParameterDescriptorGroup parameters, Class<? extends CoordinateSystem> sourceCSType, int sourceDimensions, boolean sourceOnEllipsoid, Class<? extends CoordinateSystem> targetCSType, int targetDimensions, boolean targetOnEllipsoid) {
        super(AbstractProvider.toMap(parameters), sourceDimensions, targetDimensions, parameters);
        this.operationType = operationType;
        this.sourceCSType = sourceCSType;
        this.targetCSType = targetCSType;
        this.sourceOnEllipsoid = sourceOnEllipsoid;
        this.targetOnEllipsoid = targetOnEllipsoid;
    }

    private static Map<String, Object> toMap(IdentifiedObject parameters) {
        Collection<GenericName> aliases;
        ArgumentChecks.ensureNonNull("parameters", parameters);
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", parameters.getName());
        Set<Identifier> identifiers = parameters.getIdentifiers();
        int size = identifiers.size();
        if (size != 0) {
            properties.put("identifiers", identifiers.toArray(new Identifier[size]));
        }
        if ((size = (aliases = parameters.getAlias()).size()) != 0) {
            properties.put("alias", aliases.toArray(new GenericName[size]));
        }
        return properties;
    }

    static ParameterBuilder builder() {
        return ((ParameterBuilder)new ParameterBuilder().setCodeSpace(Citations.EPSG, "EPSG")).setRequired(true);
    }

    static ParameterBuilder addNameAndLegacy(ParameterBuilder builder, String name, String legacy) {
        return (ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addName(name)).setDeprecated(true)).setRemarks(Vocabulary.formatInternational((short)190, (Object)name))).addName(legacy)).setDeprecated(false)).setRemarks(null);
    }

    static ParameterBuilder addIdentifierAndLegacy(ParameterBuilder builder, String code, String legacy) {
        return (ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier(code)).setDeprecated(true)).setRemarks(Vocabulary.formatInternational((short)190, (Object)code))).addIdentifier(legacy)).setDeprecated(false)).setRemarks(null);
    }

    static ParameterDescriptor<Double> createZeroConstant(ParameterBuilder builder) {
        Double zero = 0.0;
        return builder.createBounded(MeasurementRange.create(-0.0, true, zero, true, Units.DEGREE), zero);
    }

    static ParameterDescriptor<Double> createMandatoryLatitude(ParameterBuilder builder) {
        return builder.createBounded(-90.0, 90.0, Double.NaN, Units.DEGREE);
    }

    static ParameterDescriptor<Double> createLatitude(ParameterBuilder builder, boolean includePoles) {
        return builder.createBounded(MeasurementRange.create(-90.0, includePoles, 90.0, includePoles, Units.DEGREE), 0.0);
    }

    static ParameterDescriptor<Double> createLongitude(ParameterBuilder builder) {
        return builder.createBounded(-180.0, 180.0, 0.0, Units.DEGREE);
    }

    static ParameterDescriptor<Double> createScale(ParameterBuilder builder) {
        return builder.createStrictlyPositive(1.0, Units.UNITY);
    }

    static ParameterDescriptor<Double> createShift(ParameterBuilder builder) {
        return builder.create(0.0, Units.METRE);
    }

    public String resolveAmbiguity(DefaultMathTransformFactory.Context context) {
        return null;
    }

    @Override
    public final Class<? extends SingleOperation> getOperationType() {
        return this.operationType;
    }

    public AbstractProvider inverse() {
        return null;
    }

    static void recoverableException(Class<? extends AbstractProvider> caller, Exception e) {
        Logging.recoverableException(LOGGER, caller, "createMathTransform", e);
    }
}

