/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.NoSuchFileException;
import javax.measure.quantity.Angle;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.DatumShiftGridCompressed;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.internal.referencing.provider.DatumShiftGridLoader;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.factory.MissingFactoryResourceException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@XmlTransient
public final class NADCON
extends AbstractProvider {
    private static final long serialVersionUID = -4707304160205218546L;
    private static final ParameterDescriptor<URI> LATITUDE;
    private static final ParameterDescriptor<URI> LONGITUDE;
    private static final ParameterDescriptorGroup PARAMETERS;

    public NADCON() {
        super(Transformation.class, PARAMETERS, EllipsoidalCS.class, 2, false, EllipsoidalCS.class, 2, false);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws ParameterNotFoundException, FactoryException {
        Parameters pg = Parameters.castOrWrap(values);
        try {
            return DatumShiftGridFile.createGeodeticTransformation(NADCON.class, factory, NADCON.getOrLoad(pg.getMandatoryValue(LATITUDE), pg.getMandatoryValue(LONGITUDE)));
        }
        catch (NoSuchFileException e) {
            throw new MissingFactoryResourceException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new FactoryException(e);
        }
    }

    static DatumShiftGridFile<Angle, Angle> getOrLoad(URI latitudeShifts, URI longitudeShifts) throws Exception {
        URI rlat = Loader.toAbsolutePath(latitudeShifts);
        URI rlon = Loader.toAbsolutePath(longitudeShifts);
        return DatumShiftGridFile.getOrLoad(rlat, rlon, () -> {
            Loader loader;
            URI file = latitudeShifts;
            try {
                ByteBuffer buffer = ByteBuffer.allocate(4096).order(ByteOrder.LITTLE_ENDIAN);
                FloatBuffer fb = buffer.asFloatBuffer();
                try (ReadableByteChannel in = Loader.newByteChannel(rlat);){
                    DatumShiftGridLoader.startLoading(NADCON.class, CharSequences.commonPrefix(latitudeShifts.toString(), longitudeShifts.toString()).toString() + "\u2026");
                    loader = new Loader(in, buffer, file);
                    loader.readGrid(fb, null, longitudeShifts);
                }
                buffer.clear();
                file = longitudeShifts;
                in = Loader.newByteChannel(rlon);
                try {
                    new Loader(in, buffer, file).readGrid(fb, loader, null);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException | RuntimeException | NoninvertibleTransformException e) {
                throw DatumShiftGridLoader.canNotLoad("NADCON", file, e);
            }
            DatumShiftGridFile<Angle, Angle> grid = DatumShiftGridCompressed.compress(loader.grid, null, loader.grid.accuracy);
            return grid.useSharedData();
        }).castTo(Angle.class, Angle.class);
    }

    static {
        ParameterBuilder builder = NADCON.builder();
        LATITUDE = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8657")).addName("Latitude difference file")).create(URI.class, URI.create("conus.las"));
        LONGITUDE = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8658")).addName("Longitude difference file")).create(URI.class, URI.create("conus.los"));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("9613")).addName("NADCON")).createGroup(LATITUDE, LONGITUDE);
    }

    private static final class Loader
    extends DatumShiftGridLoader {
        private static final int DESCRIPTION_LENGTH = 64;
        private static final String NADCON = "NADCON";
        private final float x0;
        private final float y0;
        private final float \u0394x;
        private final float \u0394y;
        private final int nx;
        private final int ny;
        private final int nz;
        private final StringBuilder ascii;
        DatumShiftGridFile.Float<Angle, Angle> grid;

        Loader(ReadableByteChannel channel, ByteBuffer buffer, URI file) throws IOException, FactoryException {
            super(channel, buffer, file);
            this.ensureBufferContains(144);
            for (int i = 0; i < NADCON.length(); ++i) {
                if (buffer.get() == NADCON.charAt(i)) continue;
                throw this.unexpectedFormat();
            }
            if (Loader.isASCII(buffer)) {
                this.ascii = new StringBuilder();
                this.nx = Integer.parseInt(this.nextWord());
                this.ny = Integer.parseInt(this.nextWord());
                this.nz = Integer.parseInt(this.nextWord());
                this.x0 = Float.parseFloat(this.nextWord());
                this.\u0394x = Float.parseFloat(this.nextWord());
                this.y0 = Float.parseFloat(this.nextWord());
                this.\u0394y = Float.parseFloat(this.nextWord());
                Float.parseFloat(this.nextWord());
            } else {
                this.ascii = null;
                buffer.position(64);
                this.nx = buffer.getInt();
                this.ny = buffer.getInt();
                this.nz = buffer.getInt();
                this.x0 = buffer.getFloat();
                this.\u0394x = buffer.getFloat();
                this.y0 = buffer.getFloat();
                this.\u0394y = buffer.getFloat();
            }
            if (this.nx < 8 || this.ny < 1 || this.nz < 1 || !(this.\u0394x > 0.0f) || !(this.\u0394y > 0.0f) || Float.isNaN(this.x0) || Float.isNaN(this.y0)) {
                throw this.unexpectedFormat();
            }
            if (this.ascii == null) {
                this.skip((this.nx + 1) * 4 - buffer.position());
            }
        }

        private static boolean isASCII(ByteBuffer buffer) {
            int newLine = 0;
            while (buffer.hasRemaining()) {
                char c = (char)buffer.get();
                if (c == ' ' || c >= '+' && c <= '9' && c != ',' && c != '/') continue;
                if (c == '\r' || c == '\n') {
                    if (newLine != 0) continue;
                    newLine = buffer.position();
                    continue;
                }
                if (newLine == 0 && c >= ' ' & c <= '~') continue;
                return false;
            }
            if (newLine == 0) {
                return false;
            }
            buffer.position(newLine);
            return true;
        }

        private String nextWord() throws IOException {
            char c;
            do {
                this.ensureBufferContains(1);
            } while (Character.isWhitespace(c = (char)this.buffer.get()));
            this.ascii.setLength(0);
            do {
                this.ascii.append(c);
                this.ensureBufferContains(1);
            } while (!Character.isWhitespace(c = (char)this.buffer.get()));
            return this.ascii.toString();
        }

        private FactoryException unexpectedFormat() {
            return new FactoryException(Errors.format((short)139, NADCON, this.file));
        }

        final void readGrid(FloatBuffer fb, Loader latitudeShifts, URI longitudeShifts) throws IOException, FactoryException, NoninvertibleTransformException {
            double scale;
            int dim;
            if (latitudeShifts == null) {
                dim = 1;
                scale = 3600.0 * (double)this.\u0394y;
                this.grid = new DatumShiftGridFile.Float<Angle, Angle>(2, Units.DEGREE, Units.DEGREE, true, (double)this.x0, (double)this.y0, (double)this.\u0394x, this.\u0394y, this.nx, this.ny, PARAMETERS, this.file, longitudeShifts);
                this.grid.accuracy = 2.777777777777778E-8;
            } else {
                if (this.x0 != latitudeShifts.x0 || this.\u0394x != latitudeShifts.\u0394x || this.nx != latitudeShifts.nx || this.y0 != latitudeShifts.y0 || this.\u0394y != latitudeShifts.\u0394y || this.ny != latitudeShifts.ny || this.nz != latitudeShifts.nz) {
                    throw new FactoryException(Errors.format((short)82, latitudeShifts.file.getPath(), this.file.getPath()));
                }
                dim = 0;
                scale = -3600.0 * (double)this.\u0394x;
                this.grid = latitudeShifts.grid;
            }
            float[] array = this.grid.offsets[dim];
            if (this.ascii != null) {
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (float)(Double.parseDouble(this.nextWord()) / scale);
                }
            } else {
                int i;
                int n;
                this.syncView(fb);
                int forCurrentRow = 0;
                for (i = 0; i < array.length; i += n) {
                    int remaining;
                    if (forCurrentRow == 0) {
                        if (!fb.hasRemaining()) {
                            this.fillBuffer(fb);
                        }
                        if (fb.get() != 0.0f) {
                            throw this.unexpectedFormat();
                        }
                        forCurrentRow = this.nx;
                    }
                    if ((remaining = fb.remaining()) == 0) {
                        this.fillBuffer(fb);
                        remaining = fb.remaining();
                    }
                    n = Math.min(forCurrentRow, remaining);
                    fb.get(array, i, n);
                    forCurrentRow -= n;
                }
                i = 0;
                while (i < array.length) {
                    int n2 = i++;
                    array[n2] = (float)((double)array[n2] / scale);
                }
            }
        }

        private void fillBuffer(FloatBuffer fb) throws IOException {
            this.buffer.position(fb.position() * 4).limit(fb.limit() * 4);
            this.ensureBufferContains(4);
            this.syncView(fb);
        }

        private void syncView(FloatBuffer fb) {
            if (this.buffer.position() % 4 != 0) {
                this.buffer.compact();
            }
            fb.limit(this.buffer.limit() / 4).position(this.buffer.position() / 4);
        }
    }
}

