/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.esri;

import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.coverage.RangeArgument;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.storage.PRJDataStore;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.esri.RasterStore;
import org.apache.sis.internal.storage.esri.RawRasterLayout;
import org.apache.sis.internal.storage.esri.RawRasterReader;
import org.apache.sis.internal.storage.esri.RawRasterStoreProvider;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.Statistics;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.datum.PixelInCell;

final class RawRasterStore
extends RasterStore {
    private static final String NBANDS = "NBANDS";
    private static final String NBITS = "NBITS";
    private static final String PIXELTYPE = "PIXELTYPE";
    private static final String BYTEORDER = "BYTEORDER";
    private static final String LAYOUT = "LAYOUT";
    private static final String SKIPBYTES = "SKIPBYTES";
    private static final String BANDROWBYTES = "BANDROWBYTES";
    private static final String TOTALROWBYTES = "TOTALROWBYTES";
    private static final String BANDGAPBYTES = "BANDGAPBYTES";
    private static final String ULXMAP = "ULXMAP";
    private static final String ULYMAP = "ULYMAP";
    static final String XDIM = "XDIM";
    static final String YDIM = "YDIM";
    private static final String NODATA = "NODATA";
    private static final PixelInCell CELL_ANCHOR = PixelInCell.CELL_CENTER;
    private volatile ChannelDataInput input;
    private RawRasterReader reader;

    RawRasterStore(RawRasterStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        this.input = connector.commit(ChannelDataInput.class, "BIL/BIP/BSQ");
    }

    @Override
    public Path[] getComponentFiles() throws DataStoreException {
        return this.listComponentFiles("hdr", "prj", "stx", "clr");
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            this.getSampleDimensions();
            this.createMetadata("BIL/BIP/BSQ", "RAWGRD");
        }
        return this.metadata;
    }

    @Override
    public synchronized GridGeometry getGridGeometry() throws DataStoreException {
        if (this.reader == null) {
            try {
                this.readHeader();
            }
            catch (IOException e) {
                throw new DataStoreException(this.canNotRead(), e);
            }
            catch (RuntimeException e) {
                throw new DataStoreContentException(this.canNotRead(), e);
            }
        }
        return this.reader.gridGeometry;
    }

    @Override
    public synchronized List<SampleDimension> getSampleDimensions() throws DataStoreException {
        ChannelDataInput input = this.input;
        List<SampleDimension> sampleDimensions = super.getSampleDimensions();
        if (sampleDimensions == null) {
            try {
                if (this.reader == null) {
                    this.readHeader();
                }
                this.loadBandDescriptions(input.filename, this.reader.layout, new Statistics[0]);
                sampleDimensions = super.getSampleDimensions();
            }
            catch (IOException e) {
                throw new DataStoreException(this.canNotRead(), e);
            }
            catch (RuntimeException e) {
                throw new DataStoreContentException(this.canNotRead(), e);
            }
        }
        return sampleDimensions;
    }

    private Errors errors() {
        return Errors.getResources(this.getLocale());
    }

    private DataStoreContentException missingProperty(PRJDataStore.AuxiliaryContent header, String keyword) {
        return new DataStoreContentException(this.errors().getString((short)197, header.getFilename(), keyword));
    }

    private void ignoredProperty(String keyword, int value) {
        if (value != 0) {
            this.listeners.warning(Messages.getResources(this.getLocale()).getString((short)35, keyword));
        }
    }

    private int indexOf(String keyword, String value, String ... alternatives) {
        for (int i = 0; i < alternatives.length; ++i) {
            if (!value.equalsIgnoreCase(alternatives[i])) continue;
            return i;
        }
        this.listeners.warning(this.errors().getString((short)198, keyword, value));
        return -1;
    }

    private int parseStrictlyPositive(String keyword, String value) throws DataStoreContentException {
        int n = Integer.parseInt(value);
        if (n > 0) {
            return n;
        }
        throw new DataStoreContentException(this.errors().getString((short)165, keyword, value));
    }

    private void readHeader() throws IOException, DataStoreException {
        assert (Thread.holdsLock(this));
        ChannelDataInput input = this.input;
        if (input == null) {
            throw new DataStoreClosedException(this.canNotRead());
        }
        int nrows = 0;
        int ncols = 0;
        int nbands = 1;
        int nbits = 8;
        boolean signed = false;
        long skipBytes = 0L;
        int bandRowBytes = 0;
        int totalRowBytes = 0;
        int bandGapBytes = 0;
        double ulxmap = 0.0;
        double ulymap = 0.0;
        double xdim = 1.0;
        double ydim = 1.0;
        int geomask = 0;
        RawRasterLayout layout = RawRasterLayout.BIL;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        PRJDataStore.AuxiliaryContent header = this.readAuxiliaryFile("hdr");
        if (header == null) {
            throw new DataStoreException(Resources.forLocale(this.getLocale()).getString((short)66, "hdr"));
        }
        for (CharSequence line : CharSequences.splitOnEOL(header)) {
            int valStart;
            int valEnd;
            int length = line.length();
            int keyStart = CharSequences.skipLeadingWhitespaces(line, 0, length);
            int keyEnd = CharSequences.indexOf(line, 32, keyStart, length);
            if (keyStart < 0 || (valEnd = CharSequences.indexOf(line, 32, valStart = CharSequences.skipLeadingWhitespaces(line, keyEnd, length), length)) < 0 && (valEnd = CharSequences.skipTrailingWhitespaces(line, valStart, length)) <= valStart) continue;
            String keyword = line.subSequence(keyStart, keyEnd).toString();
            String value = line.subSequence(valStart, valEnd).toString();
            try {
                block19 : switch (keyword.toUpperCase(Locale.US)) {
                    case "NROWS": {
                        nrows = this.parseStrictlyPositive(keyword, value);
                        break;
                    }
                    case "NCOLS": {
                        ncols = this.parseStrictlyPositive(keyword, value);
                        break;
                    }
                    case "NBANDS": {
                        nbands = this.parseStrictlyPositive(keyword, value);
                        break;
                    }
                    case "NBITS": {
                        nbits = this.parseStrictlyPositive(keyword, value);
                        break;
                    }
                    case "BANDROWBYTES": {
                        bandRowBytes = this.parseStrictlyPositive(keyword, value);
                        break;
                    }
                    case "TOTALROWBYTES": {
                        totalRowBytes = this.parseStrictlyPositive(keyword, value);
                        break;
                    }
                    case "BANDGAPBYTES": {
                        bandGapBytes = Integer.parseInt(value);
                        break;
                    }
                    case "SKIPBYTES": {
                        skipBytes = Long.parseLong(value);
                        break;
                    }
                    case "ULXMAP": {
                        ulxmap = Double.parseDouble(value);
                        geomask |= 1;
                        break;
                    }
                    case "ULYMAP": {
                        ulymap = Double.parseDouble(value);
                        geomask |= 2;
                        break;
                    }
                    case "XDIM": {
                        xdim = Double.parseDouble(value);
                        geomask |= 4;
                        break;
                    }
                    case "YDIM": {
                        ydim = Double.parseDouble(value);
                        geomask |= 8;
                        break;
                    }
                    case "NODATA": {
                        this.nodataValue = Double.parseDouble(value);
                        break;
                    }
                    case "PIXELTYPE": {
                        signed = this.indexOf(keyword, value, "SIGNED", "SIGNEDINT") >= 0;
                        break;
                    }
                    case "LAYOUT": {
                        layout = RawRasterLayout.valueOf(value.toUpperCase(Locale.US));
                        break;
                    }
                    case "BYTEORDER": {
                        switch (this.indexOf(keyword, value, "I", "M")) {
                            case 0: {
                                byteOrder = ByteOrder.LITTLE_ENDIAN;
                                break block19;
                            }
                            case 1: {
                                byteOrder = ByteOrder.BIG_ENDIAN;
                                break block19;
                            }
                        }
                        throw new DataStoreContentException(this.errors().getString((short)198, keyword, value));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new DataStoreContentException(this.errors().getString((short)198, keyword, value), e);
            }
        }
        input.buffer.order(byteOrder);
        if (nrows == 0 || ncols == 0) {
            throw this.missingProperty(header, nrows == 0 ? "NROWS" : "NCOLS");
        }
        int dataType = DataType.forNumberOfBits(nbits, false, signed).toDataBufferType();
        int bytesPerSample = DataBuffer.getDataTypeSize(dataType) / 8;
        switch (geomask) {
            case 0: {
                ulymap = ncols - 1;
                break;
            }
            case 3: {
                break;
            }
            case 15: {
                break;
            }
            default: {
                String keyword;
                switch (Integer.lowestOneBit(~geomask)) {
                    case 1: {
                        keyword = ULXMAP;
                        break;
                    }
                    case 2: {
                        keyword = ULYMAP;
                        break;
                    }
                    case 4: {
                        keyword = XDIM;
                        break;
                    }
                    case 8: {
                        keyword = YDIM;
                        break;
                    }
                    default: {
                        keyword = "?";
                    }
                }
                throw this.missingProperty(header, keyword);
            }
        }
        this.readPRJ();
        GridGeometry gg = new GridGeometry(new GridExtent((long)ncols, nrows), CELL_ANCHOR, new AffineTransform2D(xdim, 0.0, 0.0, -ydim, ulxmap, ulymap), this.crs);
        SampleModel sampleModel = null;
        switch (layout) {
            case BIL: {
                this.ignoredProperty(BANDGAPBYTES, bandGapBytes);
                if (bandRowBytes == 0) {
                    bandRowBytes = Numerics.ceilDiv(Math.multiplyExact(ncols, nbits), 8);
                }
                if (totalRowBytes == 0) {
                    totalRowBytes = Math.multiplyExact(nbands, bandRowBytes);
                }
                if (bytesPerSample == 0) break;
                int bandStride = Numerics.wholeDiv(bandRowBytes, bytesPerSample);
                int scanlineStride = Numerics.wholeDiv(totalRowBytes, bytesPerSample);
                int[] bankIndices = new int[nbands];
                int[] bandOffsets = new int[nbands];
                for (int i = 1; i < nbands; ++i) {
                    bandOffsets[i] = Math.multiplyExact(bandStride, i);
                }
                sampleModel = new ComponentSampleModel(dataType, ncols, nrows, 1, scanlineStride, bankIndices, bandOffsets);
                break;
            }
            case BIP: {
                this.ignoredProperty(BANDGAPBYTES, bandGapBytes);
                this.ignoredProperty(BANDROWBYTES, bandRowBytes);
                if (totalRowBytes == 0) {
                    totalRowBytes = Numerics.ceilDiv(Math.multiplyExact(Math.multiplyExact(ncols, nbands), nbits), 8);
                }
                if (bytesPerSample == 0) break;
                int scanlineStride = Numerics.wholeDiv(totalRowBytes, bytesPerSample);
                int[] bandOffsets = ArraysExt.range(0, nbands);
                sampleModel = new PixelInterleavedSampleModel(dataType, ncols, nrows, nbands, scanlineStride, bandOffsets);
                break;
            }
            case BSQ: {
                this.ignoredProperty(BANDROWBYTES, bandRowBytes);
                if (totalRowBytes == 0) {
                    totalRowBytes = ncols;
                }
                if (bytesPerSample == 0) break;
                int scanlineStride = Numerics.wholeDiv(totalRowBytes, bytesPerSample);
                int[] bankIndices = ArraysExt.range(0, nbands);
                int[] bandOffsets = new int[nbands];
                sampleModel = new BandedSampleModel(dataType, ncols, nrows, scanlineStride, bankIndices, bandOffsets);
                break;
            }
            default: {
                throw new AssertionError((Object)layout);
            }
        }
        if (bytesPerSample == 0) {
            if (nbands != 1) {
                throw new DataStoreContentException(this.errors().getString((short)67, nbits, NBITS));
            }
            sampleModel = new MultiPixelPackedSampleModel(dataType, ncols, nrows, nbits, totalRowBytes, 0);
        }
        this.reader = new RawRasterReader(gg, sampleModel, bandGapBytes, input);
        this.reader.setOrigin(skipBytes);
    }

    @Override
    public synchronized GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        try {
            this.getSampleDimensions();
            RangeArgument bands = RangeArgument.validate(this.reader.layout.getNumBands(), ranges, this.listeners);
            WritableRaster raster = this.reader.read(domain, bands);
            return this.createCoverage(this.reader.getEffectiveDomain(), bands, raster, null);
        }
        catch (IOException e) {
            throw new DataStoreException(this.canNotRead(), e);
        }
        catch (RuntimeException e) {
            throw new DataStoreContentException(this.canNotRead(), e);
        }
    }

    private String canNotRead() {
        return Resources.forLocale(this.getLocale()).getString((short)1, "BIL/BIP/BSQ", this.getDisplayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws DataStoreException {
        block11: {
            try {
                this.listeners.close();
                ChannelDataInput input = this.input;
                if (input == null) break block11;
                try {
                    input.channel.close();
                }
                catch (IOException e) {
                    throw new DataStoreException(e);
                }
            }
            finally {
                RawRasterStore rawRasterStore = this;
                synchronized (rawRasterStore) {
                    this.input = null;
                    this.reader = null;
                    super.close();
                }
            }
        }
    }
}

