/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Collection;
import java.util.Collections;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.referencing.CommonCRS;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@XmlTransient
public abstract class GeographicEnvelope
extends AbstractEnvelope
implements GeographicBoundingBox,
Extent {
    protected GeographicEnvelope() {
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return CommonCRS.WGS84.geographic();
    }

    @Override
    public double getLower(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getSouthBoundLatitude();
            }
            case 1: {
                return this.getWestBoundLongitude();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double getUpper(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getNorthBoundLatitude();
            }
            case 1: {
                return this.getEastBoundLongitude();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Collection<? extends GeographicExtent> getGeographicElements() {
        return Collections.singleton(this);
    }

    @Override
    public Boolean getInclusion() {
        return Boolean.TRUE;
    }
}

