/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import org.apache.sis.internal.util.FinalFieldSetter;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public class QuantityFormat
extends Format
implements javax.measure.format.QuantityFormat {
    private static final long serialVersionUID = 1014042719969477503L;
    public static final char SEPARATOR = '\u202f';
    protected final NumberFormat numberFormat;
    protected final UnitFormat unitFormat;

    public QuantityFormat(Locale locale) {
        ArgumentChecks.ensureNonNull("locale", locale);
        this.numberFormat = NumberFormat.getNumberInstance(locale);
        this.unitFormat = new UnitFormat(locale);
    }

    public QuantityFormat(NumberFormat numberFormat, UnitFormat unitFormat) {
        ArgumentChecks.ensureNonNull("numberFormat", numberFormat);
        ArgumentChecks.ensureNonNull("unitFormat", unitFormat);
        this.numberFormat = numberFormat;
        this.unitFormat = unitFormat;
    }

    @Override
    public boolean isLocaleSensitive() {
        return true;
    }

    @Override
    public String format(Quantity<?> quantity) {
        return this.format(quantity, new StringBuffer(), null).toString();
    }

    @Override
    public Appendable format(Quantity<?> quantity, Appendable toAppendTo) throws IOException {
        if (toAppendTo instanceof StringBuffer) {
            return this.format(quantity, (StringBuffer)toAppendTo, null);
        }
        return toAppendTo.append(this.format(quantity, new StringBuffer(), null));
    }

    @Override
    public StringBuffer format(Object quantity, StringBuffer toAppendTo, FieldPosition pos) {
        Quantity q = (Quantity)quantity;
        if (pos == null) {
            pos = new FieldPosition(0);
        }
        toAppendTo = this.numberFormat.format(q.getValue(), toAppendTo, pos).append('\u202f');
        toAppendTo = this.unitFormat.format(q.getUnit(), toAppendTo, pos);
        return toAppendTo;
    }

    @Override
    public Quantity<?> parse(CharSequence source) throws MeasurementParseException {
        return this.parse(source, new ParsePosition(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Quantity<?> parse(CharSequence source, ParsePosition pos) throws MeasurementParseException {
        String text;
        int shift;
        int start = pos.getIndex();
        if (start == 0 || source instanceof String) {
            shift = 0;
            text = source.toString();
        } else {
            shift = start;
            text = source.subSequence(start, source.length()).toString();
            pos.setIndex(0);
        }
        try {
            Unit<?> unit;
            Number value = this.numberFormat.parse(text, pos);
            if (value != null && (unit = this.unitFormat.parse(text, pos)) != null) {
                Object obj = Quantities.create(value.doubleValue(), unit);
                return obj;
            }
        }
        finally {
            if (shift != 0) {
                pos.setIndex(pos.getIndex() + shift);
                int i = pos.getErrorIndex();
                if (i >= 0) {
                    pos.setErrorIndex(i + shift);
                }
            }
        }
        throw new MeasurementParseException(Errors.format((short)180, source), source, pos.getErrorIndex());
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        int start = pos.getIndex();
        Number value = this.numberFormat.parse(source, pos);
        if (value != null) {
            try {
                Unit<?> unit = this.unitFormat.parse(source, pos);
                if (unit != null) {
                    return Quantities.create(value.doubleValue(), unit);
                }
            }
            catch (MeasurementParseException e) {
                Logging.ignorableException(AbstractUnit.LOGGER, QuantityFormat.class, "parseObject", e);
            }
            pos.setIndex(start);
        }
        return null;
    }

    @Override
    public QuantityFormat clone() {
        QuantityFormat clone = (QuantityFormat)super.clone();
        try {
            FinalFieldSetter.set(QuantityFormat.class, "numberFormat", "unitFormat", clone, this.numberFormat.clone(), this.unitFormat.clone());
        }
        catch (ReflectiveOperationException e) {
            throw FinalFieldSetter.cloneFailure(e);
        }
        return clone;
    }
}

