/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.Individual;
import org.opengis.metadata.citation.Organisation;
import org.opengis.metadata.citation.Party;
import org.opengis.metadata.citation.Responsibility;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

@Deprecated(since="1.0")
@XmlType(name="CI_ResponsibleParty_Type", namespace="http://www.isotc211.org/2005/gmd", propOrder={"individualName", "organisationName", "positionName", "contactInfo", "role"})
@XmlRootElement(name="CI_ResponsibleParty", namespace="http://www.isotc211.org/2005/gmd")
public class DefaultResponsibleParty
extends DefaultResponsibility
implements ResponsibleParty {
    private static final long serialVersionUID = -1022635486627088812L;

    public DefaultResponsibleParty() {
    }

    public DefaultResponsibleParty(Role role) {
        super(role, null, null);
    }

    public DefaultResponsibleParty(Responsibility object) {
        super(object);
    }

    public static DefaultResponsibleParty castOrCopy(Responsibility object) {
        if (object == null || object instanceof DefaultResponsibleParty) {
            return (DefaultResponsibleParty)object;
        }
        return new DefaultResponsibleParty(object);
    }

    private InternationalString getIndividual(boolean position) {
        InternationalString name;
        block1: {
            Collection<Party> parties = this.getParties();
            name = DefaultResponsibleParty.getName(parties, Individual.class, position);
            if (name != null || parties == null) break block1;
            for (Party party : parties) {
                if (party instanceof Organisation && (name = DefaultResponsibleParty.getName(((Organisation)party).getIndividual(), Individual.class, position)) != null) break;
            }
        }
        return name;
    }

    private static InternationalString getName(Collection<? extends Party> parties, Class<? extends Party> type, boolean position) {
        InternationalString name = null;
        if (parties != null) {
            for (Party party : parties) {
                if (!type.isInstance(party)) continue;
                if (name != null) {
                    LegacyPropertyAdapter.warnIgnoredExtraneous(type, DefaultResponsibleParty.class, position ? "getPositionName" : (type == Individual.class ? "getIndividualName" : "getOrganisationName"));
                    break;
                }
                name = position ? ((Individual)party).getPositionName() : party.getName();
            }
        }
        return name;
    }

    private void setName(Class<? extends Party> type, boolean position, InternationalString name, Function<InternationalString, Party> creator) {
        Collection<Party> parties = this.getParties();
        this.checkWritePermission(ImplementationHelper.valueIfDefined(parties));
        if (parties != null) {
            Iterator<Party> it = parties.iterator();
            while (it.hasNext()) {
                Party party = it.next();
                if (!(party instanceof AbstractParty) || !type.isInstance(party)) continue;
                if (position) {
                    ((DefaultIndividual)party).setPositionName(name);
                } else {
                    ((AbstractParty)party).setName(name);
                }
                if (((AbstractParty)party).isEmpty()) {
                    it.remove();
                }
                return;
            }
        }
        if (name != null) {
            Party party = creator.apply(name);
            if (parties != null) {
                parties.add(party);
            } else {
                this.setParties(Collections.singletonList(party));
            }
        }
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getParties"})
    @XmlElement(name="individualName")
    public String getIndividualName() {
        InternationalString name = this.getIndividual(false);
        return name != null ? name.toString() : null;
    }

    @Deprecated(since="1.0")
    public void setIndividualName(String newValue) {
        this.setName(Individual.class, false, Types.toInternationalString(newValue), DefaultResponsibleParty::individual);
    }

    private static Party individual(InternationalString name) {
        return new DefaultIndividual(name, null, null);
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getParties"})
    @XmlElement(name="organisationName")
    public InternationalString getOrganisationName() {
        return DefaultResponsibleParty.getName(this.getParties(), Organisation.class, false);
    }

    @Deprecated(since="1.0")
    public void setOrganisationName(InternationalString newValue) {
        this.setName(Organisation.class, false, newValue, DefaultResponsibleParty::organisation);
    }

    private static Party organisation(InternationalString name) {
        return new DefaultOrganisation(name, null, null, null);
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getParties"})
    @XmlElement(name="positionName")
    public InternationalString getPositionName() {
        return this.getIndividual(true);
    }

    @Deprecated(since="1.0")
    public void setPositionName(InternationalString newValue) {
        this.setName(DefaultIndividual.class, true, newValue, DefaultResponsibleParty::position);
    }

    private static Party position(InternationalString name) {
        return new DefaultIndividual(null, name, null);
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getParties"})
    @XmlElement(name="contactInfo")
    public Contact getContactInfo() {
        Collection<Party> parties = this.getParties();
        if (parties != null) {
            for (Party party : parties) {
                Collection<? extends Contact> contacts = party.getContactInfo();
                if (contacts == null) continue;
                for (Contact contact : contacts) {
                    if (contact == null) continue;
                    return contact;
                }
            }
        }
        return null;
    }

    @Deprecated(since="1.0")
    public void setContactInfo(Contact newValue) {
        Collection<Party> parties = this.getParties();
        this.checkWritePermission(ImplementationHelper.valueIfDefined(parties));
        if (parties != null) {
            Iterator<Party> it = parties.iterator();
            while (it.hasNext()) {
                Party party = it.next();
                if (!(party instanceof AbstractParty)) continue;
                ((AbstractParty)party).setContactInfo(newValue != null ? Collections.singleton(newValue) : null);
                if (((AbstractParty)party).isEmpty()) {
                    it.remove();
                }
                return;
            }
        }
        if (newValue != null) {
            DefaultIndividual party = new DefaultIndividual(null, null, newValue);
            if (parties != null) {
                parties.add(party);
            } else {
                this.setParties(Collections.singletonList(party));
            }
        }
    }

    @Override
    @XmlElement(name="role", required=true)
    public Role getRole() {
        return super.getRole();
    }

    @Override
    public void setRole(Role newValue) {
        super.setRole(newValue);
    }
}

