/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.citation.DefaultTelephone;
import org.opengis.metadata.citation.Telephone;
import org.opengis.metadata.citation.TelephoneType;

final class LegacyTelephones
extends LegacyPropertyAdapter<String, Telephone> {
    private final TelephoneType type;

    LegacyTelephones(Collection<Telephone> telephones, TelephoneType type) {
        super(telephones);
        this.type = type;
    }

    @Override
    protected Telephone wrap(String value) {
        return new DefaultTelephone(value, this.type);
    }

    @Override
    protected String unwrap(Telephone container) {
        if (container != null && this.type.equals(container.getNumberType())) {
            return container.getNumber();
        }
        return null;
    }

    @Override
    protected boolean update(Telephone container, String value) {
        TelephoneType ct;
        if (container instanceof DefaultTelephone && ((ct = container.getNumberType()) == null || ct.equals(this.type))) {
            if (ct == null) {
                ((DefaultTelephone)container).setNumberType(this.type);
            }
            ((DefaultTelephone)container).setNumber(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(String value) {
        Telephone telephone;
        if (value == null || value.isEmpty()) {
            return false;
        }
        Iterator it = this.elements.iterator();
        if (it.hasNext() && (telephone = (Telephone)it.next()) instanceof DefaultTelephone && ((DefaultTelephone)telephone).isEmpty() && this.update(telephone, value)) {
            return true;
        }
        return this.elements.add(this.wrap(value));
    }
}

