/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.content.AttributeGroup;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.content.RangeDimension;

@XmlType(name="MD_AttributeGroup_Type", propOrder={"contentTypes", "attributes"})
@XmlRootElement(name="MD_AttributeGroup")
public class DefaultAttributeGroup
extends ISOMetadata
implements AttributeGroup {
    private static final long serialVersionUID = -2198484393626051875L;
    private Collection<CoverageContentType> contentTypes;
    private Collection<RangeDimension> attributes;

    public DefaultAttributeGroup() {
    }

    public DefaultAttributeGroup(CoverageContentType contentType, RangeDimension attribute) {
        this.contentTypes = this.singleton(contentType, CoverageContentType.class);
        this.attributes = this.singleton(attribute, RangeDimension.class);
    }

    public DefaultAttributeGroup(AttributeGroup object) {
        super(object);
        if (object != null) {
            this.contentTypes = this.copyCollection(object.getContentTypes(), CoverageContentType.class);
            this.attributes = this.copyCollection(object.getAttributes(), RangeDimension.class);
        }
    }

    public static DefaultAttributeGroup castOrCopy(AttributeGroup object) {
        if (object == null || object instanceof DefaultAttributeGroup) {
            return (DefaultAttributeGroup)object;
        }
        return new DefaultAttributeGroup(object);
    }

    @Override
    @XmlElement(name="contentType", required=true)
    public Collection<CoverageContentType> getContentTypes() {
        this.contentTypes = this.nonNullCollection(this.contentTypes, CoverageContentType.class);
        return this.contentTypes;
    }

    public void setContentTypes(Collection<? extends CoverageContentType> newValues) {
        this.contentTypes = this.writeCollection(newValues, this.contentTypes, CoverageContentType.class);
    }

    @XmlElement(name="attribute")
    public Collection<RangeDimension> getAttributes() {
        this.attributes = this.nonNullCollection(this.attributes, RangeDimension.class);
        return this.attributes;
    }

    public void setAttributes(Collection<? extends RangeDimension> newValues) {
        this.attributes = this.writeCollection(newValues, this.attributes, RangeDimension.class);
    }
}

