/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.content.FeatureTypeInfo;
import org.opengis.util.GenericName;

@TitleProperty(name="featureTypeName")
@XmlType(name="MD_FeatureTypeInfo_Type", propOrder={"featureTypeName", "featureInstanceCount"})
@XmlRootElement(name="MD_FeatureTypeInfo")
public class DefaultFeatureTypeInfo
extends ISOMetadata
implements FeatureTypeInfo {
    private static final long serialVersionUID = -4103901642915981422L;
    private GenericName featureTypeName;
    private Integer featureInstanceCount;

    public DefaultFeatureTypeInfo() {
    }

    public DefaultFeatureTypeInfo(GenericName featureTypeName) {
        this.featureTypeName = featureTypeName;
    }

    public DefaultFeatureTypeInfo(FeatureTypeInfo object) {
        super(object);
        if (object != null) {
            this.featureTypeName = object.getFeatureTypeName();
            this.featureInstanceCount = object.getFeatureInstanceCount();
        }
    }

    public static DefaultFeatureTypeInfo castOrCopy(FeatureTypeInfo object) {
        if (object == null || object instanceof DefaultFeatureTypeInfo) {
            return (DefaultFeatureTypeInfo)object;
        }
        return new DefaultFeatureTypeInfo(object);
    }

    @Override
    @XmlElement(name="featureTypeName", required=true)
    public GenericName getFeatureTypeName() {
        return this.featureTypeName;
    }

    public void setFeatureTypeName(GenericName newValue) {
        this.checkWritePermission(this.featureTypeName);
        this.featureTypeName = newValue;
    }

    @Override
    @ValueRange(minimum=1.0)
    @XmlElement(name="featureInstanceCount")
    public Integer getFeatureInstanceCount() {
        return this.featureInstanceCount;
    }

    public void setFeatureInstanceCount(Integer newValue) {
        this.checkWritePermission(this.featureInstanceCount);
        if (ImplementationHelper.ensurePositive(DefaultFeatureTypeInfo.class, "featureInstanceCount", true, newValue)) {
            this.featureInstanceCount = newValue;
        }
    }
}

