/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.metadata.CI_Citation;
import org.apache.sis.internal.jaxb.metadata.MD_Medium;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.Distributor;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.distribution.Medium;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Format_Type", propOrder={"name", "version", "amendmentNumber", "specification", "formatSpecificationCitation", "fileDecompressionTechnique", "media", "formatDistributors"})
@XmlRootElement(name="MD_Format")
public class DefaultFormat
extends ISOMetadata
implements Format {
    private static final long serialVersionUID = -8346373589075887348L;
    private Citation formatSpecificationCitation;
    private InternationalString amendmentNumber;
    private InternationalString fileDecompressionTechnique;
    private Collection<Medium> media;
    private Collection<Distributor> formatDistributors;

    public DefaultFormat() {
    }

    public DefaultFormat(Format object) {
        super(object);
        if (object != null) {
            this.formatSpecificationCitation = object.getFormatSpecificationCitation();
            this.amendmentNumber = object.getAmendmentNumber();
            this.fileDecompressionTechnique = object.getFileDecompressionTechnique();
            this.media = this.copyCollection(object.getMedia(), Medium.class);
            this.formatDistributors = this.copyCollection(object.getFormatDistributors(), Distributor.class);
        }
    }

    public static DefaultFormat castOrCopy(Format object) {
        if (object == null || object instanceof DefaultFormat) {
            return (DefaultFormat)object;
        }
        return new DefaultFormat(object);
    }

    @Override
    @XmlElement(name="formatSpecificationCitation", required=true)
    @XmlJavaTypeAdapter(value=CI_Citation.Since2014.class)
    public Citation getFormatSpecificationCitation() {
        return this.formatSpecificationCitation;
    }

    public void setFormatSpecificationCitation(Citation newValue) {
        this.checkWritePermission(this.formatSpecificationCitation);
        this.formatSpecificationCitation = newValue;
    }

    private <T> void setFormatSpecificationCitation(BiConsumer<DefaultCitation, T> setter, T value) {
        Citation citation = this.formatSpecificationCitation;
        if (citation != null || value != null) {
            if (!(citation instanceof DefaultCitation)) {
                citation = new DefaultCitation(citation);
            }
            setter.accept((DefaultCitation)citation, (DefaultCitation)value);
            if (value == null && ((DefaultCitation)citation).isEmpty()) {
                citation = null;
            }
        }
        if (citation != this.formatSpecificationCitation) {
            this.setFormatSpecificationCitation(citation);
        }
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getFormatSpecificationCitation"})
    @XmlElement(name="specification", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getSpecification() {
        Citation citation;
        if (FilterByVersion.LEGACY_METADATA.accept() && (citation = this.getFormatSpecificationCitation()) != null) {
            return citation.getTitle();
        }
        return null;
    }

    @Deprecated(since="1.0")
    public void setSpecification(InternationalString newValue) {
        this.checkWritePermission(this.formatSpecificationCitation);
        this.setFormatSpecificationCitation((citation, value) -> citation.setTitle((InternationalString)value), newValue);
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getFormatSpecificationCitation"})
    @XmlElement(name="name", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getName() {
        Citation citation;
        if (FilterByVersion.LEGACY_METADATA.accept() && (citation = this.getFormatSpecificationCitation()) != null) {
            return LegacyPropertyAdapter.getSingleton(citation.getAlternateTitles(), InternationalString.class, null, DefaultFormat.class, "getName");
        }
        return null;
    }

    @Deprecated(since="1.0")
    public void setName(InternationalString newValue) {
        this.checkWritePermission(this.formatSpecificationCitation);
        this.setFormatSpecificationCitation((citation, value) -> citation.setAlternateTitles(CollectionsExt.singletonOrEmpty(value)), newValue);
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getFormatSpecificationCitation"})
    @XmlElement(name="version", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getVersion() {
        Citation citation;
        if (FilterByVersion.LEGACY_METADATA.accept() && (citation = this.getFormatSpecificationCitation()) != null) {
            return citation.getEdition();
        }
        return null;
    }

    @Deprecated(since="1.0")
    public void setVersion(InternationalString newValue) {
        this.checkWritePermission(this.formatSpecificationCitation);
        this.setFormatSpecificationCitation((citation, value) -> citation.setEdition((InternationalString)value), newValue);
    }

    @Override
    @XmlElement(name="amendmentNumber")
    public InternationalString getAmendmentNumber() {
        return this.amendmentNumber;
    }

    public void setAmendmentNumber(InternationalString newValue) {
        this.checkWritePermission(this.amendmentNumber);
        this.amendmentNumber = newValue;
    }

    @Override
    @XmlElement(name="fileDecompressionTechnique")
    public InternationalString getFileDecompressionTechnique() {
        return this.fileDecompressionTechnique;
    }

    public void setFileDecompressionTechnique(InternationalString newValue) {
        this.checkWritePermission(this.fileDecompressionTechnique);
        this.fileDecompressionTechnique = newValue;
    }

    @XmlElement(name="medium")
    @XmlJavaTypeAdapter(value=MD_Medium.Since2014.class)
    public Collection<Medium> getMedia() {
        this.media = this.nonNullCollection(this.media, Medium.class);
        return this.media;
    }

    public void setMedia(Collection<? extends Medium> newValues) {
        this.media = this.writeCollection(newValues, this.media, Medium.class);
    }

    @XmlElement(name="formatDistributor")
    public Collection<Distributor> getFormatDistributors() {
        this.formatDistributors = this.nonNullCollection(this.formatDistributors, Distributor.class);
        return this.formatDistributors;
    }

    public void setFormatDistributors(Collection<? extends Distributor> newValues) {
        this.formatDistributors = this.writeCollection(newValues, this.formatDistributors, Distributor.class);
    }
}

