/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.net.URI;
import java.util.Collection;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gcx.MimeFileTypeAdapter;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.util.InternationalString;

@XmlType(name="MD_BrowseGraphic_Type", namespace="http://standards.iso.org/iso/19115/-3/mcc/1.0", propOrder={"fileName", "fileDescription", "fileType", "linkage", "imageConstraint"})
@XmlRootElement(name="MD_BrowseGraphic", namespace="http://standards.iso.org/iso/19115/-3/mcc/1.0")
public class DefaultBrowseGraphic
extends ISOMetadata
implements BrowseGraphic {
    private static final long serialVersionUID = 1769063690091153678L;
    private URI fileName;
    private InternationalString fileDescription;
    private String fileType;
    private Collection<Constraints> imageConstraints;
    private Collection<OnlineResource> linkages;

    public DefaultBrowseGraphic() {
    }

    public DefaultBrowseGraphic(URI fileName) {
        this.fileName = fileName;
    }

    public DefaultBrowseGraphic(BrowseGraphic object) {
        super(object);
        if (object != null) {
            this.fileName = object.getFileName();
            this.fileDescription = object.getFileDescription();
            this.fileType = object.getFileType();
            this.imageConstraints = this.copyCollection(object.getImageConstraints(), Constraints.class);
            this.linkages = this.copyCollection(object.getLinkages(), OnlineResource.class);
        }
    }

    public static DefaultBrowseGraphic castOrCopy(BrowseGraphic object) {
        if (object == null || object instanceof DefaultBrowseGraphic) {
            return (DefaultBrowseGraphic)object;
        }
        return new DefaultBrowseGraphic(object);
    }

    @Override
    @XmlElement(name="fileName", required=true)
    public URI getFileName() {
        return this.fileName;
    }

    public void setFileName(URI newValue) {
        this.checkWritePermission(this.fileName);
        this.fileName = newValue;
    }

    @Override
    @XmlElement(name="fileDescription")
    public InternationalString getFileDescription() {
        return this.fileDescription;
    }

    public void setFileDescription(InternationalString newValue) {
        this.checkWritePermission(this.fileDescription);
        this.fileDescription = newValue;
    }

    @Override
    @XmlElement(name="fileType")
    @XmlJavaTypeAdapter(value=MimeFileTypeAdapter.class)
    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String newValue) {
        this.checkWritePermission(this.fileType);
        this.fileType = newValue;
    }

    public Collection<Constraints> getImageConstraints() {
        this.imageConstraints = this.nonNullCollection(this.imageConstraints, Constraints.class);
        return this.imageConstraints;
    }

    public void setImageConstraints(Collection<? extends Constraints> newValues) {
        this.imageConstraints = this.writeCollection(newValues, this.imageConstraints, Constraints.class);
    }

    public Collection<OnlineResource> getLinkages() {
        this.linkages = this.nonNullCollection(this.linkages, OnlineResource.class);
        return this.linkages;
    }

    public void setLinkages(Collection<? extends OnlineResource> newValues) {
        this.linkages = this.writeCollection(newValues, this.linkages, OnlineResource.class);
    }

    @XmlElement(name="imageConstraints")
    private Collection<Constraints> getImageConstraint() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getImageConstraints() : null;
    }

    @XmlElement(name="linkage")
    private Collection<OnlineResource> getLinkage() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getLinkages() : null;
    }
}

