/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.GO_GenericName;
import org.apache.sis.internal.jaxb.metadata.SV_OperationMetadata;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.identification.OperationName;
import org.apache.sis.util.iso.Names;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.CoupledResource;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.OperationMetadata;
import org.opengis.util.ScopedName;

@XmlType(name="SV_CoupledResource_Type", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", propOrder={"scopedName", "resourceReference", "resource", "operation", "operationName", "id", "legacyName"})
@XmlRootElement(name="SV_CoupledResource", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0")
public class DefaultCoupledResource
extends ISOMetadata
implements CoupledResource {
    private static final long serialVersionUID = 154704781596732747L;
    private ScopedName scopedName;
    private Collection<Citation> resourceReferences;
    private Collection<DataIdentification> resources;
    private OperationMetadata operation;

    public DefaultCoupledResource() {
    }

    public DefaultCoupledResource(ScopedName name, Citation reference, DataIdentification resource, OperationMetadata operation) {
        this.scopedName = name;
        this.resourceReferences = this.singleton(reference, Citation.class);
        this.resources = this.singleton(resource, DataIdentification.class);
        this.operation = operation;
    }

    public DefaultCoupledResource(CoupledResource object) {
        super(object);
        if (object != null) {
            this.scopedName = object.getScopedName();
            this.resourceReferences = this.copyCollection(object.getResourceReferences(), Citation.class);
            this.resources = this.copyCollection(object.getResources(), DataIdentification.class);
            this.operation = object.getOperation();
        }
    }

    public static DefaultCoupledResource castOrCopy(CoupledResource object) {
        if (object == null || object instanceof DefaultCoupledResource) {
            return (DefaultCoupledResource)object;
        }
        return new DefaultCoupledResource(object);
    }

    @Override
    @XmlElement(name="scopedName")
    @XmlJavaTypeAdapter(value=GO_GenericName.Since2014.class)
    public ScopedName getScopedName() {
        return this.scopedName;
    }

    public void setScopedName(ScopedName newValue) {
        this.checkWritePermission(this.scopedName);
        this.scopedName = newValue;
    }

    public Collection<Citation> getResourceReferences() {
        this.resourceReferences = this.nonNullCollection(this.resourceReferences, Citation.class);
        return this.resourceReferences;
    }

    public void setResourceReferences(Collection<? extends Citation> newValues) {
        this.resourceReferences = this.writeCollection(newValues, this.resourceReferences, Citation.class);
    }

    public Collection<DataIdentification> getResources() {
        this.resources = this.nonNullCollection(this.resources, DataIdentification.class);
        return this.resources;
    }

    public void setResources(Collection<? extends DataIdentification> newValues) {
        this.resources = this.writeCollection(newValues, this.resources, DataIdentification.class);
    }

    @Override
    @XmlElement(name="operation")
    @XmlJavaTypeAdapter(value=SV_OperationMetadata.Since2014.class)
    public OperationMetadata getOperation() {
        return this.operation;
    }

    public void setOperation(OperationMetadata newValue) {
        this.checkWritePermission(this.operation);
        this.operation = newValue;
    }

    @XmlElement(name="operationName", namespace="http://www.isotc211.org/2005/srv")
    private String getOperationName() {
        OperationMetadata operation;
        if (FilterByVersion.LEGACY_METADATA.accept() && (operation = this.getOperation()) != null) {
            return operation.getOperationName();
        }
        return null;
    }

    private void setOperationName(String name) {
        if (this.operation == null) {
            this.operation = new OperationName(name);
        }
    }

    @XmlElement(name="identifier", namespace="http://www.isotc211.org/2005/srv")
    private String getId() {
        ScopedName name;
        if (FilterByVersion.LEGACY_METADATA.accept() && (name = this.getScopedName()) != null) {
            return name.tip().toString();
        }
        return null;
    }

    @XmlElement(name="ScopedName", namespace="http://standards.iso.org/iso/19115/-3/gco/1.0")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String getLegacyName() {
        ScopedName name;
        if (FilterByVersion.LEGACY_METADATA.accept() && (name = this.getScopedName()) != null) {
            return name.toString();
        }
        return null;
    }

    private void setLegacyName(String value) {
        if (value != null && !((String)value).isEmpty()) {
            if (((String)value).indexOf(58) < 0) {
                value = "global:" + (String)value;
            }
            this.setScopedName((ScopedName)Names.parseGenericName(null, null, (CharSequence)value));
        }
    }

    @XmlElement(name="resourceReference")
    private Collection<Citation> getResourceReference() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getResourceReferences() : null;
    }

    @XmlElement(name="resource")
    private Collection<DataIdentification> getResource() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getResources() : null;
    }
}

