/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.List;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.identification.DistributedComputingPlatform;
import org.opengis.metadata.identification.OperationMetadata;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.util.InternationalString;

@TitleProperty(name="operationName")
@XmlType(name="SV_OperationMetadata_Type", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", propOrder={"operationName", "distributedComputingPlatforms", "operationDescription", "invocationName", "connectPoints", "parameters", "dependsOn"})
@XmlRootElement(name="SV_OperationMetadata", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0")
public class DefaultOperationMetadata
extends ISOMetadata
implements OperationMetadata {
    private static final long serialVersionUID = -6120853428175790473L;
    private String operationName;
    private Collection<DistributedComputingPlatform> distributedComputingPlatforms;
    private InternationalString operationDescription;
    private InternationalString invocationName;
    private Collection<OnlineResource> connectPoints;
    private Collection<ParameterDescriptor<?>> parameters;
    private List<OperationMetadata> dependsOn;

    public DefaultOperationMetadata() {
    }

    public DefaultOperationMetadata(String operationName, DistributedComputingPlatform platform, OnlineResource connectPoint) {
        this.operationName = operationName;
        this.distributedComputingPlatforms = this.singleton(platform, DistributedComputingPlatform.class);
        this.connectPoints = this.singleton(connectPoint, OnlineResource.class);
    }

    public DefaultOperationMetadata(OperationMetadata object) {
        super(object);
        if (object != null) {
            this.operationName = object.getOperationName();
            this.distributedComputingPlatforms = this.copyCollection(object.getDistributedComputingPlatforms(), DistributedComputingPlatform.class);
            this.operationDescription = object.getOperationDescription();
            this.invocationName = object.getInvocationName();
            this.connectPoints = this.copyCollection(object.getConnectPoints(), OnlineResource.class);
            this.parameters = this.copySet(object.getParameters(), ParameterDescriptor.class);
            this.dependsOn = this.copyList(object.getDependsOn(), OperationMetadata.class);
        }
    }

    public static DefaultOperationMetadata castOrCopy(OperationMetadata object) {
        if (object == null || object instanceof DefaultOperationMetadata) {
            return (DefaultOperationMetadata)object;
        }
        return new DefaultOperationMetadata(object);
    }

    @Override
    @XmlElement(name="operationName", required=true)
    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String newValue) {
        this.checkWritePermission(this.operationName);
        this.operationName = newValue;
    }

    @Override
    @XmlElement(name="distributedComputingPlatform", required=true)
    public Collection<DistributedComputingPlatform> getDistributedComputingPlatforms() {
        this.distributedComputingPlatforms = this.nonNullCollection(this.distributedComputingPlatforms, DistributedComputingPlatform.class);
        return this.distributedComputingPlatforms;
    }

    public void setDistributedComputingPlatforms(Collection<? extends DistributedComputingPlatform> newValues) {
        this.distributedComputingPlatforms = this.writeCollection(newValues, this.distributedComputingPlatforms, DistributedComputingPlatform.class);
    }

    @Override
    @XmlElement(name="operationDescription")
    public InternationalString getOperationDescription() {
        return this.operationDescription;
    }

    public void setOperationDescription(InternationalString newValue) {
        this.checkWritePermission(this.operationDescription);
        this.operationDescription = newValue;
    }

    @Override
    @XmlElement(name="invocationName")
    public InternationalString getInvocationName() {
        return this.invocationName;
    }

    public void setInvocationName(InternationalString newValue) {
        this.checkWritePermission(this.invocationName);
        this.invocationName = newValue;
    }

    @XmlElement(name="connectPoint", required=true)
    public Collection<OnlineResource> getConnectPoints() {
        this.connectPoints = this.nonNullCollection(this.connectPoints, OnlineResource.class);
        return this.connectPoints;
    }

    public void setConnectPoints(Collection<? extends OnlineResource> newValue) {
        this.connectPoints = this.writeCollection(newValue, this.connectPoints, OnlineResource.class);
    }

    @XmlElement(name="parameter")
    public Collection<ParameterDescriptor<?>> getParameters() {
        this.parameters = this.nonNullCollection(this.parameters, ParameterDescriptor.class);
        return this.parameters;
    }

    public void setParameters(Collection<? extends ParameterDescriptor<?>> newValues) {
        this.parameters = this.writeCollection(newValues, this.parameters, ParameterDescriptor.class);
    }

    @XmlElement(name="dependsOn")
    public List<OperationMetadata> getDependsOn() {
        this.dependsOn = this.nonNullList(this.dependsOn, OperationMetadata.class);
        return this.dependsOn;
    }

    public void setDependsOn(List<? extends OperationMetadata> newValues) {
        this.dependsOn = this.writeList(newValues, this.dependsOn, OperationMetadata.class);
    }
}

