/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.temporal.Temporal;
import org.apache.sis.internal.jaxb.gco.GO_Temporal;
import org.apache.sis.internal.jaxb.metadata.MD_Scope;
import org.apache.sis.metadata.iso.quality.DefaultConformanceResult;
import org.apache.sis.metadata.iso.quality.DefaultCoverageResult;
import org.apache.sis.metadata.iso.quality.DefaultDescriptiveResult;
import org.apache.sis.metadata.iso.quality.DefaultQuantitativeResult;
import org.apache.sis.metadata.iso.quality.ISOMetadata;
import org.opengis.metadata.maintenance.Scope;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.metadata.quality.CoverageResult;
import org.opengis.metadata.quality.DescriptiveResult;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.metadata.quality.Result;

@XmlType(name="AbstractDQ_Result_Type", propOrder={"resultScope", "dateTime"})
@XmlRootElement(name="AbstractDQ_Result")
@XmlSeeAlso(value={DefaultConformanceResult.class, DefaultQuantitativeResult.class, DefaultDescriptiveResult.class, DefaultCoverageResult.class})
public class AbstractResult
extends ISOMetadata
implements Result {
    private static final long serialVersionUID = 3510023908820052467L;
    private Scope resultScope;
    private Temporal dateTime;

    public AbstractResult() {
    }

    public AbstractResult(Result object) {
        super(object);
        if (object != null) {
            this.resultScope = object.getResultScope();
            this.dateTime = object.getDateTime();
        }
    }

    public static AbstractResult castOrCopy(Result object) {
        if (object instanceof QuantitativeResult) {
            return DefaultQuantitativeResult.castOrCopy((QuantitativeResult)object);
        }
        if (object instanceof ConformanceResult) {
            return DefaultConformanceResult.castOrCopy((ConformanceResult)object);
        }
        if (object instanceof DescriptiveResult) {
            return DefaultDescriptiveResult.castOrCopy((DescriptiveResult)object);
        }
        if (object instanceof CoverageResult) {
            return DefaultCoverageResult.castOrCopy((CoverageResult)object);
        }
        if (object == null || object instanceof AbstractResult) {
            return (AbstractResult)object;
        }
        return new AbstractResult(object);
    }

    @Override
    @XmlElement(name="resultScope")
    @XmlJavaTypeAdapter(value=MD_Scope.Since2014.class)
    public Scope getResultScope() {
        return this.resultScope;
    }

    public void setResultScope(Scope newValue) {
        this.resultScope = newValue;
    }

    @Override
    @XmlElement(name="dateTime")
    @XmlJavaTypeAdapter(value=GO_Temporal.Since2014.class)
    public Temporal getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(Temporal newValue) {
        this.dateTime = newValue;
    }
}

