/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.quality.AbstractResult;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.quality.DescriptiveResult;
import org.opengis.util.InternationalString;

@XmlType(name="DQ_DescriptiveResult_Type", propOrder={"statement"})
@XmlRootElement(name="DQ_DescriptiveResult")
public class DefaultDescriptiveResult
extends AbstractResult
implements DescriptiveResult {
    private static final long serialVersionUID = 5786649528259918304L;
    private InternationalString statement;

    public DefaultDescriptiveResult() {
    }

    public DefaultDescriptiveResult(CharSequence text) {
        this.statement = Types.toInternationalString(text);
    }

    public DefaultDescriptiveResult(DescriptiveResult object) {
        super(object);
        if (object != null) {
            this.statement = object.getStatement();
        }
    }

    public static DefaultDescriptiveResult castOrCopy(DescriptiveResult object) {
        if (object == null || object instanceof DefaultDescriptiveResult) {
            return (DefaultDescriptiveResult)object;
        }
        return new DefaultDescriptiveResult(object);
    }

    @Override
    @XmlElement(name="statement", required=true)
    public InternationalString getStatement() {
        return this.statement;
    }

    public void setStatement(InternationalString newValue) {
        this.checkWritePermission(this.statement);
        this.statement = newValue;
    }
}

